/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.adapter.value.BooleanValue;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.AbstractFieldSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Shape;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.field.AbstractField;

public class CheckboxField
extends AbstractField {
    private static final int size = Toolkit.getText("normal").getTextHeight();

    public CheckboxField(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        Color color = this.getIdentified() ? Toolkit.getColor("secondary2") : null;
        color = this.hasFocus() ? Toolkit.getColor("identified") : color;
        int top = VPADDING;
        int left = HPADDING;
        if (color != null) {
            canvas.drawRectangle(left - 2, top - 2, size + 4, size + 4, color);
        }
        color = Toolkit.getColor("black");
        canvas.drawRectangle(left, top, size, size, color);
        if (this.isSet()) {
            Shape tick = new Shape(0, 6);
            tick.addVertex(4, 12);
            tick.addVertex(12, 0);
            tick.addVertex(4, 8);
            canvas.drawSolidShape(tick, 3, 3, color);
        }
    }

    public void firstClick(Click click) {
        this.toggle();
    }

    public void keyTyped(char keyCode) {
        if (keyCode == ' ') {
            this.toggle();
        } else {
            super.keyTyped(keyCode);
        }
    }

    private void toggle() {
        if (this.canChangeValue().isAllowed()) {
            this.initiateSave();
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("normal").getAscent();
    }

    public Size getMaximumSize() {
        return new Size(HPADDING + size + HPADDING, VPADDING + size + VPADDING);
    }

    private boolean isSet() {
        BooleanValue value = (BooleanValue)this.getContent().getNaked();
        return value.isSet();
    }

    protected void save() {
        BooleanValue value = (BooleanValue)this.getContent().getNaked();
        value.toggle();
        this.markDamaged();
        ((ValueContent)this.getContent()).entryComplete();
        this.getParent().invalidateContent();
    }

    public static class Specification
    extends AbstractFieldSpecification {
        public boolean canDisplay(Content content) {
            return content.isValue() && content.getNaked() instanceof BooleanValue;
        }

        public View createView(Content content, ViewAxis axis) {
            return new CheckboxField(content, this, axis);
        }

        public String getName() {
            return "Checkbox";
        }
    }
}

