/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.view.field.AbstractField;
import org.nakedobjects.nos.client.dnd.view.field.AbstractValueOption;

public class ClearValueOption
extends AbstractValueOption {
    private final AbstractField field;

    public ClearValueOption(AbstractField field) {
        super("Clear");
        this.field = field;
    }

    public String getDescription(View view) {
        return "Clear field";
    }

    public Consent disabled(View view) {
        NakedValue value = this.getValue(view);
        ValueContent field = (ValueContent)view.getContent();
        Consent changable = view.canChangeValue();
        if (changable.isVetoed()) {
            return changable;
        }
        if (!field.canClear()) {
            return new Veto("Can't clear " + value.getSpecification().getShortName() + " values");
        }
        if (this.isEmpty(view)) {
            return new Veto("Field is already empty");
        }
        return new Allow("Clear value " + value.titleString());
    }

    public void execute(Workspace frame, View view, Location at) {
        this.field.clear();
    }

    public String toString() {
        return "ClearValueOption";
    }
}

