/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.value.ColorValue;
import org.nakedobjects.nof.core.util.NotImplementedException;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.border.DisposeOverlay;
import org.nakedobjects.nos.client.dnd.builder.AbstractFieldSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.field.AbstractField;
import org.nakedobjects.nos.client.dnd.view.field.ColorFieldOverlay;

public class ColorField
extends AbstractField {
    private int color;

    public ColorField(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        Color color = this.hasFocus() ? Toolkit.getColor("primary1") : (this.getParent().getState().isObjectIdentified() ? Toolkit.getColor("identified") : (this.getParent().getState().isRootViewIdentified() ? Toolkit.getColor("primary2") : Toolkit.getColor("secondary1")));
        int top = 0;
        int left = 0;
        Size size = this.getSize();
        int w = size.getWidth() - 1;
        int h = size.getHeight() - 1;
        canvas.drawRectangle(left, top, w, h, color);
        canvas.drawSolidRectangle(++left, ++top, --w, --h, Toolkit.getColor(this.getColor()));
    }

    public void firstClick(Click click) {
        if (((ValueContent)this.getContent()).isEditable().isAllowed()) {
            DisposeOverlay overlay = new DisposeOverlay(new ColorFieldOverlay(this));
            Location location = this.getAbsoluteLocation();
            overlay.setLocation(location);
            this.getViewManager().setOverlayView(overlay);
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("normal").getAscent();
    }

    int getColor() {
        ValueContent content = (ValueContent)this.getContent();
        ColorValue value = (ColorValue)content.getObject();
        return value.color();
    }

    public Size getMaximumSize() {
        return new Size(45, 15);
    }

    protected void save() {
        try {
            this.parseEntry("" + this.color);
        }
        catch (InvalidEntryException e) {
            throw new NotImplementedException();
        }
    }

    void setColor(int color) {
        this.color = color;
        this.initiateSave();
    }

    public static class Specification
    extends AbstractFieldSpecification {
        public boolean canDisplay(Content content) {
            return content.isValue() && content.getNaked() instanceof ColorValue;
        }

        public View createView(Content content, ViewAxis axis) {
            return new ColorField(content, this, axis);
        }

        public String getName() {
            return "Color";
        }
    }
}

