/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.field;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.value.ImageValue;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.ValueField;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.builder.AbstractFieldSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.image.AwtImage;
import org.nakedobjects.nos.client.dnd.view.field.AbstractField;

public class ImageField
extends AbstractField {
    private static final Logger LOG = Logger.getLogger(ImageField.class);
    private static final MediaTracker mt = new MediaTracker(new java.awt.Canvas());

    public ImageField(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public boolean canFocus() {
        return true;
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        options.add(new AbstractUserAction("Load image from file..."){

            public void execute(Workspace workspace, View view, Location at) {
                String file = ImageField.this.getViewManager().selectFilePath("Load image", ".");
                ImageField.this.loadImageFromFile(file);
            }
        });
    }

    private void copy() {
    }

    public void draw(Canvas canvas) {
        Color color = this.hasFocus() ? Toolkit.getColor("primary1") : (this.getParent().getState().isObjectIdentified() ? Toolkit.getColor("identified") : (this.getParent().getState().isRootViewIdentified() ? Toolkit.getColor("primary2") : Toolkit.getColor("secondary1")));
        int top = 0;
        int left = 0;
        Size size = this.getSize();
        int w = size.getWidth() - 1;
        int h = size.getHeight() - 1;
        canvas.drawRectangle(left, top, w, h, color);
        ++left;
        ++top;
        --w;
        --h;
        ImageValue value = (ImageValue)this.getContent().getNaked();
        Image image = value.getImage();
        if (image != null) {
            Size imageSize = new Size(value.getWidth(), value.getHeight());
            if (imageSize.getWidth() <= w && imageSize.getHeight() <= h) {
                canvas.drawImage(new AwtImage(image), left, top);
            } else {
                canvas.drawImage(new AwtImage(image), left, top, w, h);
            }
        }
    }

    public int getBaseline() {
        return VPADDING + Toolkit.getText("normal").getAscent();
    }

    public Size getMaximumSize() {
        Size size = new Size(60, 60);
        return size;
    }

    public Size getRequiredSize(Size maximumSize) {
        ImageValue value = (ImageValue)this.getContent().getNaked();
        if (value.isEmpty()) {
            return super.getRequiredSize(maximumSize);
        }
        int width = Math.min(120, Math.max(32, value.getWidth()));
        int height = Math.min(120, Math.max(32, value.getHeight()));
        return new Size(width, height);
    }

    public void keyPressed(KeyboardAction key) {
        if (this.canChangeValue().isVetoed()) {
            return;
        }
        int keyCode = key.getKeyCode();
        if (keyCode == 17 || keyCode == 16 || keyCode == 18) {
            return;
        }
        int modifiers = key.getModifiers();
        boolean ctrl = (modifiers & 2) > 0;
        switch (keyCode) {
            case 86: {
                if (!ctrl) break;
                key.consume();
                this.pasteFromClipboard();
                break;
            }
            case 67: {
                if (!ctrl) break;
                key.consume();
                this.copy();
            }
        }
    }

    private void loadImage(Image image) {
        mt.addImage(image, 1);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException e) {
            throw new NakedObjectRuntimeException((Throwable)e);
        }
        ImageValue value = (ImageValue)this.getContent().getNaked();
        value.setImage(image);
        ((ValueField)this.getContent()).entryComplete();
        this.invalidateLayout();
    }

    private void loadImageFromURL(String filename) {
        try {
            URL url = new URL("file://" + filename);
            Image image = java.awt.Toolkit.getDefaultToolkit().getImage(url);
            this.loadImage(image);
        }
        catch (MalformedURLException e) {
            throw new NakedObjectRuntimeException("Failed to load image from " + filename);
        }
    }

    private void loadImageFromFile(String filename) {
        Image image = java.awt.Toolkit.getDefaultToolkit().getImage(filename);
        this.loadImage(image);
    }

    void pasteFromClipboard() {
        Clipboard cb = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable content = cb.getContents(this);
        try {
            if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String filename = (String)content.getTransferData(DataFlavor.stringFlavor);
                LOG.debug((Object)("pasted image from " + filename));
                this.loadImageFromFile("file://" + filename);
            } else {
                LOG.info((Object)("unsupported paste operation " + content));
            }
        }
        catch (Throwable e) {
            LOG.error((Object)("invalid paste operation " + e));
        }
    }

    protected void save() {
    }

    public static class Specification
    extends AbstractFieldSpecification {
        public boolean canDisplay(Content content) {
            return content.isValue() && content.getNaked() instanceof ImageValue;
        }

        public View createView(Content content, ViewAxis axis) {
            return new ImageField(content, this, axis);
        }

        public String getName() {
            return "Image";
        }
    }
}

