/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.field;

import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.field.AbstractField;
import org.nakedobjects.nos.client.dnd.view.field.ClearValueOption;

public class PasswordField
extends AbstractField {
    protected static final Text style = Toolkit.getText("normal");
    private boolean isSaved;
    private int maxTextWidth;
    private String password;
    private boolean identified;
    private char echoCharacter;

    public PasswordField(Content content, ViewSpecification design, ViewAxis axis) {
        super(content, design, axis);
        this.setMaxTextWidth(20);
        String echoCharacterSetting = NakedObjectsContext.getConfiguration().getString("nakedobjects.viewer.dnd.echo");
        this.echoCharacter = echoCharacterSetting == null || echoCharacterSetting.equals(" ") ? (char)42 : echoCharacterSetting.charAt(0);
        this.password = this.text();
    }

    public void contentMenuOptions(UserActionSet options) {
        options.add(new ClearValueOption(this));
        options.setColor(Toolkit.getColor("background.value-menu"));
    }

    void clear() {
        this.password = "";
        this.editComplete();
    }

    private void delete() {
        this.isSaved = false;
        int lastChar = this.password.length() - 1;
        this.password = this.password.substring(0, Math.max(0, lastChar));
        this.markDamaged();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Color color = this.identified ? Toolkit.getColor("identified") : Toolkit.getColor("secondary2");
        color = this.hasFocus() ? Toolkit.getColor("primary1") : color;
        int baseline = this.getBaseline();
        canvas.drawLine(HPADDING, baseline, HPADDING + this.getSize().getWidth(), baseline, color);
        String echoedPassword = this.echoPassword();
        int x = 3;
        Color textColor = this.hasFocus() ? Toolkit.getColor("text.edit") : Toolkit.getColor("text.saved");
        canvas.drawText(echoedPassword, x, this.getBaseline(), textColor, style);
        x += style.stringWidth(echoedPassword);
        if (this.hasFocus() && this.canChangeValue().isAllowed()) {
            canvas.drawLine(x, baseline + style.getDescent(), x, 0, Toolkit.getColor("primary1"));
        }
    }

    private String echoPassword() {
        int length = this.password.length();
        String echoedPassword = "";
        for (int i = 0; i < length; ++i) {
            echoedPassword = echoedPassword + this.echoCharacter;
        }
        return echoedPassword;
    }

    public void editComplete() {
        if (this.canChangeValue().isAllowed() && !this.isSaved) {
            this.isSaved = true;
            this.initiateSave();
        }
    }

    public void escape() {
        this.password = "";
        this.isSaved = false;
        this.markDamaged();
    }

    public void entered() {
        if (this.canChangeValue().isAllowed()) {
            this.getFeedbackManager().showTextCursor();
            this.identified = true;
            this.markDamaged();
        }
    }

    public void exited() {
        if (this.canChangeValue().isAllowed()) {
            this.getFeedbackManager().showDefaultCursor();
            this.identified = false;
            this.markDamaged();
        }
    }

    public void focusLost() {
        this.editComplete();
    }

    public Size getMaximumSize() {
        int width = HPADDING + this.maxTextWidth + HPADDING;
        int height = style.getTextHeight() + VPADDING;
        height = Math.max(height, Toolkit.defaultFieldHeight());
        return new Size(width, height);
    }

    public void keyPressed(KeyboardAction key) {
        if (!this.canChangeValue().isAllowed()) {
            return;
        }
        int keyCode = key.getKeyCode();
        if (keyCode == 17 || keyCode == 16 || keyCode == 18) {
            return;
        }
        switch (keyCode) {
            case 37: {
                key.consume();
                this.delete();
                break;
            }
            case 127: {
                key.consume();
                this.delete();
                break;
            }
            case 8: {
                key.consume();
                this.delete();
                break;
            }
            case 9: {
                this.editComplete();
                break;
            }
            case 10: {
                key.consume();
                this.editComplete();
                this.getParent().keyPressed(key);
                break;
            }
            case 27: {
                key.consume();
                this.escape();
                break;
            }
        }
    }

    public void keyTyped(char keyCode) {
        this.password = this.password + keyCode;
        this.isSaved = false;
        this.markDamaged();
    }

    protected void save() {
        ValueContent content = (ValueContent)this.getContent();
        content.parseTextEntry(this.password);
        content.entryComplete();
    }

    public void setMaxTextWidth(int noCharacters) {
        this.maxTextWidth = style.charWidth('o') * noCharacters;
    }

    public void setMaxWidth(int width) {
        this.maxTextWidth = width;
    }

    private String text() {
        ValueContent content = (ValueContent)this.getContent();
        String text = content.getNaked().titleString();
        return text;
    }
}

