/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.field;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.InvalidEntryException;
import org.nakedobjects.noa.adapter.NakedValue;
import org.nakedobjects.noa.adapter.TextEntryParseException;
import org.nakedobjects.noa.persist.ConcurrencyException;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.InternalDrag;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.SimpleInternalDrag;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.border.PanelBorder;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.field.AbstractField;
import org.nakedobjects.nos.client.dnd.view.field.RevertFieldOption;
import org.nakedobjects.nos.client.dnd.view.simple.TextView;
import org.nakedobjects.nos.client.dnd.view.text.CursorPosition;
import org.nakedobjects.nos.client.dnd.view.text.TextBlockTarget;
import org.nakedobjects.nos.client.dnd.view.text.TextContent;
import org.nakedobjects.nos.client.dnd.view.text.TextSelection;

public abstract class TextField
extends AbstractField
implements TextBlockTarget {
    private static final Logger LOG = Logger.getLogger(TextField.class);
    protected static final Text style = Toolkit.getText("normal");
    protected CursorPosition cursor;
    private boolean identified;
    private String invalidReason = null;
    private boolean isSaved = true;
    private int maxLength;
    private int displayWidth;
    protected TextSelection selection;
    private boolean showLines;
    protected TextContent textContent;

    public TextField(ValueContent content, ViewSpecification specification, ViewAxis axis, boolean showLines, int wrapStyle) {
        super(content, specification, axis);
        this.showLines = showLines;
        int typicalLength = content.getTypicalLineLength();
        typicalLength = typicalLength == 0 ? 20 : typicalLength / content.getNoLines();
        this.setTextWidth(typicalLength);
        this.maxLength = content.getMaximumLength();
        NakedValue value = this.getValue();
        this.textContent = new TextContent(this, 1, wrapStyle);
        this.cursor = new CursorPosition(this.textContent, 0, 0);
        this.selection = new TextSelection(this.textContent);
        this.textContent.setText(value == null ? "" : value.titleString());
        this.cursor.home();
        this.isSaved = true;
    }

    protected abstract void align();

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        options.add(new RevertFieldOption(this));
    }

    void clear() {
        this.clearValue();
        this.editComplete();
    }

    void clearValue() {
        this.textContent.setText("");
        this.cursor.home();
        this.selection.resetTo(this.cursor);
        this.changeMade();
    }

    void copyToClipboard() {
        boolean noSelection = this.selection.to().samePosition(this.selection.from());
        String text = noSelection ? this.textContent.getText() : this.textContent.getText(this.selection);
        this.getViewManager().setClipboard(text, String.class);
        LOG.debug((Object)("copied " + text));
    }

    public void debug(DebugString debug) {
        debug.appendln("text", (Object)this.textContent);
    }

    public void delete() {
        if (this.selection.hasSelection()) {
            this.textContent.delete(this.selection);
            this.selection.resetTo(this.selection.from());
        } else {
            this.textContent.deleteLeft(this.cursor);
            this.cursor.left();
            this.selection.resetTo(this.cursor);
        }
        this.changeMade();
    }

    public void deleteForward() {
        if (this.selection.hasSelection()) {
            this.textContent.delete(this.selection);
            this.selection.resetTo(this.selection.from());
        } else {
            this.textContent.deleteRight(this.cursor);
        }
        this.changeMade();
    }

    protected void down(boolean shift) {
        this.cursor.lineDown();
        this.highlight(shift);
        this.markDamaged();
    }

    public void drag(InternalDrag drag) {
        if (this.canChangeValue().isAllowed()) {
            this.selection.extendTo(drag.getLocation());
            this.markDamaged();
        }
    }

    public Drag dragStart(DragStart drag) {
        Location at = drag.getLocation();
        Size size = this.getView().getSize();
        Location anchor = this.getView().getAbsoluteLocation();
        ViewAxis axis = this.getViewAxis();
        if (axis instanceof LabelAxis) {
            int width = ((LabelAxis)axis).getWidth();
            size.contractWidth(width);
            anchor.add(width, 0);
        }
        if (this.canChangeValue().isAllowed()) {
            this.cursor.cursorAt(at);
            this.resetSelection();
            return new SimpleInternalDrag((View)this, anchor);
        }
        this.markDamaged();
        return null;
    }

    public void dragTo(InternalDrag drag) {
        Location at = drag.getLocation();
        if (this.canChangeValue().isAllowed()) {
            this.selection.extendTo(at);
            this.markDamaged();
        }
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int width = this.getMaxFieldWidth();
        this.align();
        if (this.hasFocus() && this.selection.hasSelection()) {
            this.drawHighlight(canvas, width);
        }
        if (this.showLines && this.canChangeValue().isAllowed()) {
            Color color = this.identified ? Toolkit.getColor("identified") : Toolkit.getColor("secondary2");
            color = this.hasFocus() ? Toolkit.getColor("primary1") : color;
            this.drawLines(canvas, color, width);
        }
        Color textColor = this.getState().isInvalid() ? Toolkit.getColor("black") : (this.hasFocus() ? (this.isSaved ? Toolkit.getColor("text.saved") : Toolkit.getColor("text.edit")) : Toolkit.getColor("black"));
        this.drawText(canvas, textColor, width);
    }

    protected abstract void drawHighlight(Canvas var1, int var2);

    protected abstract void drawLines(Canvas var1, Color var2, int var3);

    protected abstract void drawText(Canvas var1, Color var2, int var3);

    public void editComplete() {
        if (this.canChangeValue().isAllowed() && !this.isSaved) {
            this.isSaved = true;
            this.initiateSave();
        }
    }

    protected void end(boolean alt, boolean shift) {
        if (alt) {
            this.cursor.bottom();
        } else {
            this.cursor.end();
        }
        this.highlight(shift);
        this.markDamaged();
    }

    protected boolean enter() {
        this.editComplete();
        return false;
    }

    public void entered() {
        if (this.canChangeValue().isAllowed()) {
            this.getFeedbackManager().showTextCursor();
            this.identified = true;
            this.markDamaged();
        }
        super.entered();
    }

    protected void escape() {
        if (this.isSaved) {
            this.clearValue();
        } else {
            this.invalidReason = null;
            this.refresh();
            this.markDamaged();
        }
    }

    public void exited() {
        if (this.canChangeValue().isAllowed()) {
            this.getFeedbackManager().showDefaultCursor();
            this.identified = false;
            this.markDamaged();
        }
        super.exited();
    }

    public void firstClick(Click click) {
        if (this.canChangeValue().isAllowed()) {
            Location at = click.getLocation();
            at.subtract(HPADDING, VPADDING);
            this.cursor.cursorAt(at);
            this.resetSelection();
            if (this.cursor.getLine() > this.textContent.getNoLinesOfContent()) {
                throw new NakedObjectRuntimeException("not inside content for line " + this.cursor.getLine() + " : " + this.textContent.getNoLinesOfContent());
            }
            this.markDamaged();
        }
        if (!this.canChangeValue().isAllowed() || click.isShift() || click.button2()) {
            PanelBorder textView = new PanelBorder(1, Toolkit.getColor("primary1"), Toolkit.getColor("primary3"), new TextView(this.getContent().getNaked().titleString()));
            this.getViewManager().setOverlayView(textView);
            textView.setLocation(this.getAbsoluteLocation());
            textView.markDamaged();
        }
    }

    public void focusLost() {
        super.focusLost();
        this.editComplete();
    }

    public void focusReceived() {
        this.getFeedbackManager().setError(this.invalidReason == null ? "" : this.invalidReason);
        this.resetSelection();
    }

    public int getBaseline() {
        return this.getText().getAscent();
    }

    public Size getMaximumSize() {
        int width = HPADDING + this.displayWidth + HPADDING;
        int height = this.textContent.getNoDisplayLines() == 1 ? this.getText().getTextHeight() : this.textContent.getNoDisplayLines() * this.getText().getLineHeight();
        height = Math.max(height, Toolkit.defaultFieldHeight());
        return new Size(width, height);
    }

    public int getMaxFieldWidth() {
        return this.displayWidth;
    }

    public Text getText() {
        return style;
    }

    String getSelectedText() {
        return this.textContent.getText(this.selection);
    }

    private NakedValue getValue() {
        return (NakedValue)this.getContent().getNaked();
    }

    private void highlight(boolean select) {
        if (this.canChangeValue().isAllowed()) {
            if (!select) {
                this.selection.resetTo(this.cursor);
            } else {
                this.selection.extendTo(this.cursor);
            }
        }
    }

    protected void home(boolean alt, boolean shift) {
        if (alt) {
            this.cursor.top();
        } else {
            this.cursor.home();
        }
        this.highlight(shift);
        this.markDamaged();
    }

    private void insert(char character) {
        if (this.withinMaximum(1)) {
            this.insert("" + character);
            this.selection.resetTo(this.cursor);
        } else {
            this.getFeedbackManager().setError("Entry can be no longer than " + this.maxLength + " characters");
        }
    }

    private void changeMade() {
        this.isSaved = false;
        this.markDamaged();
        if (this.getState().isInvalid()) {
            this.getState().clearInvalid();
        }
    }

    private void insert(String characters) {
        if (this.withinMaximum(characters.length())) {
            int noLines = this.textContent.getNoDisplayLines();
            this.textContent.insert(this.cursor, characters);
            this.cursor.right(characters.length());
            if (this.textContent.getNoDisplayLines() != noLines) {
                this.invalidateLayout();
            }
            this.changeMade();
        } else {
            this.getFeedbackManager().setError("Entry can be no longer than " + this.maxLength + " characters");
        }
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public void keyPressed(KeyboardAction key) {
        if (!this.canChangeValue().isAllowed()) {
            return;
        }
        int keyCode = key.getKeyCode();
        if (keyCode == 17 || keyCode == 16 || keyCode == 18) {
            return;
        }
        int modifiers = key.getModifiers();
        boolean alt = (modifiers & 8) > 0;
        boolean shift = (modifiers & 1) > 0;
        boolean ctrl = (modifiers & 2) > 0;
        switch (keyCode) {
            case 33: {
                key.consume();
                this.pageUp(shift, ctrl);
                break;
            }
            case 34: {
                key.consume();
                this.pageDown(shift, ctrl);
                break;
            }
            case 86: {
                if (!ctrl) break;
                key.consume();
                this.pasteFromClipboard();
                this.highlight(false);
                break;
            }
            case 67: {
                if (!ctrl) break;
                key.consume();
                this.copyToClipboard();
                break;
            }
            case 40: {
                key.consume();
                this.down(shift);
                break;
            }
            case 38: {
                key.consume();
                this.up(shift);
                break;
            }
            case 36: {
                key.consume();
                this.home(alt, shift);
                break;
            }
            case 35: {
                key.consume();
                this.end(alt, shift);
                break;
            }
            case 37: {
                key.consume();
                this.left(alt, shift);
                break;
            }
            case 39: {
                key.consume();
                this.right(alt, shift);
                break;
            }
            case 127: {
                key.consume();
                this.deleteForward();
                break;
            }
            case 8: {
                key.consume();
                this.delete();
                break;
            }
            case 9: {
                this.tab();
                break;
            }
            case 10: {
                if (this.enter()) break;
                this.getParent().keyPressed(key);
                break;
            }
            case 27: {
                key.consume();
                this.escape();
                break;
            }
        }
        LOG.debug((Object)("character at " + this.cursor.getCharacter() + " line " + this.cursor.getLine()));
        LOG.debug((Object)this.selection);
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
        if (this.canChangeValue().isAllowed()) {
            this.insert(keyCode);
        }
    }

    protected void left(boolean alt, boolean shift) {
        if (alt) {
            this.cursor.wordLeft();
        } else {
            this.cursor.left();
        }
        this.highlight(shift);
        this.markDamaged();
    }

    protected void pageDown(boolean shift, boolean ctrl) {
        if (ctrl) {
            if (this.textContent.decreaseDepth()) {
                this.textContent.alignDisplay(this.cursor.getLine());
                this.invalidateLayout();
            }
        } else {
            this.cursor.pageDown();
            this.highlight(shift);
        }
        this.markDamaged();
    }

    protected void pageUp(boolean shift, boolean ctrl) {
        if (ctrl) {
            this.textContent.increaseDepth();
            this.textContent.alignDisplay(this.cursor.getLine());
            this.invalidateLayout();
        } else {
            this.cursor.pageUp();
            this.highlight(shift);
        }
        this.markDamaged();
    }

    void pasteFromClipboard() {
        try {
            String text = (String)this.getViewManager().getClipboard(String.class);
            this.insert(text);
            LOG.debug((Object)("pasted " + text));
        }
        catch (Throwable e) {
            LOG.error((Object)("invalid paste operation " + e));
        }
    }

    public void refresh() {
        super.refresh();
        NakedValue object = this.getValue();
        if (object == null) {
            this.textContent.setText("");
        } else {
            String value = object.titleString();
            this.textContent.setText(value);
        }
        this.isSaved = true;
    }

    private void resetSelection() {
        this.selection.resetTo(this.cursor);
    }

    protected void right(boolean alt, boolean shift) {
        if (alt) {
            this.cursor.wordRight();
        } else {
            this.cursor.right();
        }
        this.highlight(shift);
        this.markDamaged();
    }

    protected void save() {
        NakedValue value;
        String entry = this.textContent.getText();
        if (!entry.equals((value = this.getValue()) == null ? "" : value.titleString())) {
            LOG.debug((Object)("field edited: '" + entry + "' to replace '" + (value == null ? "" : value.titleString()) + "'"));
            try {
                this.parseEntry(entry.toString());
                this.invalidReason = null;
                this.getViewManager().getSpy().addAction("VALID ENTRY: " + entry);
                this.markDamaged();
                this.getParent().invalidateContent();
            }
            catch (TextEntryParseException e) {
                this.invalidReason = "INVALID ENTRY: " + e.getMessage();
                this.getFeedbackManager().setError(this.invalidReason);
                this.getState().setInvalid();
                this.markDamaged();
            }
            catch (InvalidEntryException e) {
                this.invalidReason = "INVALID ENTRY: " + e.getMessage();
                this.getFeedbackManager().setError(this.invalidReason);
                this.getState().setInvalid();
                this.markDamaged();
            }
            catch (ConcurrencyException e) {
                this.invalidReason = "UPDATE FAILURE: " + e.getMessage();
                this.getState().setOutOfSynch();
                this.markDamaged();
                throw e;
            }
            catch (NakedObjectRuntimeException e) {
                this.invalidReason = "UPDATE FAILURE: " + e.getMessage();
                this.getFeedbackManager().setError(this.invalidReason);
                this.getState().setOutOfSynch();
                this.markDamaged();
                throw e;
            }
        }
    }

    public void secondClick(Click click) {
        if (this.canChangeValue().isAllowed()) {
            this.selection.selectWord();
        }
    }

    private void setTextWidth(int noCharacters) {
        this.displayWidth = this.getText().charWidth('5') * (noCharacters + 3);
    }

    public void setWidth(int width) {
        this.displayWidth = width;
    }

    public void setSize(Size size) {
        super.setSize(size);
        this.setWidth(size.getWidth() - 2 * HPADDING);
    }

    protected void tab() {
        this.editComplete();
    }

    public void thirdClick(Click click) {
        if (this.canChangeValue().isAllowed()) {
            this.selection.selectSentence();
            this.markDamaged();
        }
    }

    protected void up(boolean shift) {
        this.cursor.lineUp();
        this.highlight(shift);
        this.markDamaged();
    }

    private boolean withinMaximum(int characters) {
        return this.maxLength == 0 || this.textContent.getText().length() + characters <= this.maxLength;
    }

    void revertInvalidEntry() {
        this.invalidReason = null;
        this.refresh();
        this.cursor.home();
        this.getState().clearInvalid();
        this.markDamaged();
    }

    public boolean hasInvalidEntry() {
        return this.invalidReason != null;
    }
}

