/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.field;

import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.field.TextField;
import org.nakedobjects.nos.client.dnd.view.text.CursorPosition;

public class WrappedTextField
extends TextField {
    private static final Logger LOG = Logger.getLogger(WrappedTextField.class);

    public WrappedTextField(ValueContent content, ViewSpecification specification, ViewAxis axis, boolean showLines) {
        super(content, specification, axis, showLines, 0);
    }

    public void debug(DebugString debug) {
        debug.appendln("text", (Object)this.textContent);
    }

    public void setWrapping(boolean wrapping) {
    }

    protected void drawLines(Canvas canvas, Color color, int width) {
        int baseline = this.getBaseline();
        int noDisplayLines = this.textContent.getNoDisplayLines();
        for (int line = 0; line < noDisplayLines; ++line) {
            canvas.drawLine(HPADDING, baseline, HPADDING + width, baseline, color);
            baseline += this.getText().getLineHeight();
        }
    }

    protected void drawHighlight(Canvas canvas, int maxWidth) {
        int baseline = this.getBaseline();
        int top = baseline - style.getAscent();
        CursorPosition from = this.selection.from();
        CursorPosition to = this.selection.to();
        String[] lines = this.textContent.getDisplayLines();
        int displayFromLine = this.textContent.getDisplayFromLine();
        int displayToLine = displayFromLine + lines.length;
        for (int i = displayFromLine; i <= displayToLine; ++i) {
            if (i >= from.getLine() && i <= to.getLine()) {
                int at;
                String line = this.textContent.getText(i);
                int start = 0;
                int end = style.stringWidth(line);
                if (from.getLine() == i) {
                    at = Math.min(from.getCharacter(), line.length());
                    start = style.stringWidth(line.substring(0, at));
                }
                if (to.getLine() == i) {
                    at = Math.min(to.getCharacter(), line.length());
                    end = style.stringWidth(line.substring(0, at));
                }
                canvas.drawSolidRectangle(start + HPADDING, top, end - start, this.getText().getLineHeight(), Toolkit.getColor("text.highlight"));
            }
            top += this.getText().getLineHeight();
        }
    }

    protected void drawText(Canvas canvas, Color textColor, int width) {
        int baseline = this.getBaseline();
        String[] lines = this.textContent.getDisplayLines();
        int cursorLine = this.cursor.getLine() - this.textContent.getDisplayFromLine();
        for (int i = 0; i < lines.length; ++i) {
            String chars = lines[i];
            if (chars == null) {
                throw new NakedObjectRuntimeException();
            }
            if (chars.endsWith("\n")) {
                throw new RuntimeException();
            }
            if (this.hasFocus() && this.canChangeValue().isAllowed() && cursorLine == i) {
                int at = Math.min(this.cursor.getCharacter(), chars.length());
                int pos = style.stringWidth(chars.substring(0, at)) + HPADDING;
                canvas.drawLine(pos, baseline + style.getDescent(), pos, baseline - style.getAscent(), Toolkit.getColor("text.cursor"));
            }
            canvas.drawText(chars, HPADDING, baseline, textColor, style);
            baseline += this.getText().getLineHeight();
        }
    }

    protected boolean enter() {
        this.textContent.breakBlock(this.cursor);
        this.cursor.lineDown();
        this.cursor.home();
        this.markDamaged();
        return true;
    }

    public void setNoLines(int noLines) {
        this.textContent.setNoDisplayLines(noLines);
    }

    public void setSize(Size size) {
        super.setSize(size);
        this.textContent.setNoDisplayLines(size.getHeight() / style.getLineHeight());
    }

    public void setMaximumSize(Size size) {
        int lines = Math.max(1, size.getHeight() / this.getText().getLineHeight());
        this.setNoLines(lines);
        int width = Math.max(180, size.getWidth() - HPADDING);
        this.setWidth(width);
        LOG.debug((Object)(lines + " x " + width));
        this.invalidateLayout();
    }

    protected void align() {
    }
}

