/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.form;

import org.nakedobjects.nof.core.util.UnknownTypeException;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.LabelAxis;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.OneToManyField;
import org.nakedobjects.nos.client.dnd.SubviewSpec;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ValueField;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewFactory;
import org.nakedobjects.nos.client.dnd.border.DroppableLabelBorder;
import org.nakedobjects.nos.client.dnd.border.LabelBorder;
import org.nakedobjects.nos.client.dnd.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.nos.client.dnd.builder.ObjectFieldBuilder;
import org.nakedobjects.nos.client.dnd.builder.StackLayout;
import org.nakedobjects.nos.client.dnd.focus.SubviewFocusManager;

public abstract class AbstractFormSpecification
extends AbstractCompositeViewSpecification
implements SubviewSpec {
    public AbstractFormSpecification() {
        this.builder = new StackLayout(new ObjectFieldBuilder(this), false);
    }

    public boolean canDisplay(Content content) {
        return content.isObject();
    }

    public View createView(Content content, ViewAxis axis) {
        this.resolveObject(content);
        View formView = super.createView(content, new LabelAxis());
        View completeView = this.decorateView(formView);
        completeView.setFocusManager(new SubviewFocusManager(completeView));
        return completeView;
    }

    protected abstract View decorateView(View var1);

    public View createSubview(Content content, ViewAxis axis) {
        ViewFactory factory = Toolkit.getViewFactory();
        View subview = null;
        if (content.isObject()) {
            subview = this.createObjectSubview(factory, content, axis);
        } else if (content.isValue()) {
            subview = this.createValueSubview(content, axis, factory);
        } else if (content.isCollection()) {
            subview = this.createCollectionSubview(content, axis, factory);
        } else {
            throw new UnknownTypeException((Object)content);
        }
        return subview;
    }

    protected View createCollectionSubview(Content content, ViewAxis axis, ViewFactory factory) {
        return LabelBorder.createFieldLabelBorder(factory.createInternalList((OneToManyField)content, axis));
    }

    protected View createValueSubview(Content content, ViewAxis axis, ViewFactory factory) {
        return LabelBorder.createFieldLabelBorder(factory.createFieldView((ValueField)content, axis));
    }

    protected View createObjectSubview(ViewFactory factory, Content content, ViewAxis axis) {
        return DroppableLabelBorder.createObjectFieldLabelBorder(factory.createFieldView((ObjectContent)content, axis));
    }
}

