/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.form;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedCollection;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.CollectionContent;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.OneToManyField;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.border.AbstractBorder;
import org.nakedobjects.nos.client.dnd.content.OptionFactory;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.form.InternalCollectionIconGraphic;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;

public class InternalCollectionBorder
extends AbstractBorder {
    private IconGraphic icon = new InternalCollectionIconGraphic((View)this, Toolkit.getText("normal"));

    protected InternalCollectionBorder(View wrappedView) {
        super(wrappedView);
        this.left = this.icon.getSize().getWidth();
    }

    protected void debugDetails(DebugString debug) {
        debug.append((Object)"InternalCollectionBorder ");
    }

    public Size getRequiredSize(Size maximumSize) {
        Size size = super.getRequiredSize(maximumSize);
        size.ensureWidth(this.left + 45 + this.right);
        size.ensureHeight(24);
        return size;
    }

    public void draw(Canvas canvas) {
        this.icon.draw(canvas, 0, this.getBaseline());
        CollectionContent content = (CollectionContent)((Object)this.getContent());
        NakedCollection collection = content.getCollection();
        if (collection == null || collection.size() == 0) {
            canvas.drawText("empty", this.left, this.getBaseline(), Toolkit.getColor("secondary2"), Toolkit.getText("normal"));
        } else {
            int x = this.icon.getSize().getWidth() / 2;
            int x2 = x + 4;
            int y = this.icon.getSize().getHeight() + 1;
            int y2 = this.getSize().getHeight() - 5;
            canvas.drawLine(x, y, x, y2, Toolkit.getColor("secondary2"));
            canvas.drawLine(x, y2, x2, y2, Toolkit.getColor("secondary2"));
        }
        super.draw(canvas);
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        NakedObjectSpecification nakedClass = ((OneToManyField)this.getContent()).getSpecification();
        OptionFactory.addCreateOptions(nakedClass, options);
    }

    public void objectActionResult(Naked result, Location at) {
        NakedObject target;
        OneToManyField internalCollectionContent = (OneToManyField)this.getContent();
        OneToManyAssociation field = internalCollectionContent.getOneToManyAssociation();
        Consent valid = field.isValidToAdd(target = ((ObjectContent)this.getParent().getContent()).getObject(), (NakedObject)result);
        if (valid.isAllowed()) {
            field.addElement(target, (NakedObject)result);
        }
        super.objectActionResult(result, at);
    }

    public String toString() {
        return "InternalCollectionBorder/" + this.wrappedView;
    }
}

