/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.help;

import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;
import org.nakedobjects.nos.client.dnd.view.text.TextBlockTarget;
import org.nakedobjects.nos.client.dnd.view.text.TextContent;

public class HelpView
extends AbstractView
implements TextBlockTarget {
    private static final int HEIGHT = 350;
    private static final int WIDTH = 400;
    private static final int MAX_TEXT_WIDTH = 375;
    private TextContent content;

    public HelpView(String name, String description, String help) {
        String text = (name == null || name.trim().equals("") ? "" : name + "\n") + (description == null || description.trim().equals("") ? "" : description + "\n") + (help == null ? "" : help);
        this.content = new TextContent(this, 10, 0);
        this.content.setText(text);
    }

    public void draw(Canvas canvas) {
        int x = 0;
        int y = 0;
        int xEntent = this.getSize().getWidth() - 1;
        int yExtent = this.getSize().getHeight() - 1;
        int arc = 9;
        canvas.drawSolidRectangle(x + 2, y + 2, xEntent - 4, yExtent - 4, Toolkit.getColor("white"));
        canvas.drawRoundedRectangle(x, y++, xEntent, yExtent, arc, arc, Toolkit.getColor("black"));
        canvas.drawRoundedRectangle(x + 1, y++, xEntent - 2, yExtent - 2, arc, arc, Toolkit.getColor("secondary2"));
        canvas.drawRoundedRectangle(x + 2, y++, xEntent - 4, yExtent - 4, arc, arc, Toolkit.getColor("black"));
        y += VPADDING;
        canvas.drawText("Help", x += 10, y += Toolkit.getText("title").getTextHeight(), Toolkit.getColor("black"), Toolkit.getText("title"));
        String[] lines = this.content.getDisplayLines();
        for (int i = 0; i < lines.length; ++i) {
            canvas.drawText(lines[i], x, y += Toolkit.getText("normal").getLineHeight(), 375, Toolkit.getColor("black"), Toolkit.getText("normal"));
        }
    }

    public Size getMaximumSize() {
        return new Size(400, 350);
    }

    public Size getRequiredSize(Size maximumSize) {
        int height = Math.min(350, maximumSize.getHeight());
        int width = Math.min(400, maximumSize.getWidth());
        return new Size(width, height);
    }

    public void firstClick(Click click) {
        this.getViewManager().clearOverlayView(this);
    }

    public int getMaxFieldWidth() {
        return 380;
    }

    public Text getText() {
        return Toolkit.getText("normal");
    }
}

