/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.message;

import java.util.StringTokenizer;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.message.MessageContent;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;

class DetailedMessageView
extends AbstractView {
    protected DetailedMessageView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public Size getMaximumSize() {
        Size size = new Size();
        size.extendHeight(Toolkit.getText("title").getTextHeight());
        size.extendHeight(30);
        String message = ((MessageContent)this.getContent()).getMessage();
        size.ensureWidth(500);
        size.extendHeight(Toolkit.getText("normal").stringHeight(message, 500));
        size.extendHeight(30);
        String detail = ((MessageContent)this.getContent()).getDetail();
        StringTokenizer st = new StringTokenizer(detail, "\n\r");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            size.ensureWidth((line.startsWith("\t") ? 20 : 0) + Toolkit.getText("normal").stringWidth(line));
            size.extendHeight(Toolkit.getText("normal").getTextHeight());
        }
        size.extend(40, 20);
        return size;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int left = 10;
        int y = 10 + Toolkit.getText("title").getAscent();
        String message = ((MessageContent)this.getContent()).getMessage();
        String heading = ((MessageContent)this.getContent()).title();
        String detail = ((MessageContent)this.getContent()).getDetail();
        canvas.drawText(heading, left, y, Toolkit.getColor("black"), Toolkit.getText("title"));
        canvas.drawText(message, left, y += Toolkit.getText("title").getTextHeight(), 500, Toolkit.getColor("black"), Toolkit.getText("normal"));
        canvas.drawText(detail, left, y += Toolkit.getText("normal").stringHeight(message, 500), 1000, Toolkit.getColor("primary1"), Toolkit.getText("normal"));
    }

    public ViewAreaType viewAreaType(Location mouseLocation) {
        return ViewAreaType.VIEW;
    }
}

