/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.message;

import org.nakedobjects.nof.core.util.DebugOutput;
import org.nakedobjects.nos.client.dnd.ButtonAction;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractButtonAction;
import org.nakedobjects.nos.client.dnd.action.CancelAction;
import org.nakedobjects.nos.client.dnd.border.ButtonBorder;
import org.nakedobjects.nos.client.dnd.border.DialogBorder;
import org.nakedobjects.nos.client.dnd.border.ScrollBorder;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.view.message.DetailedMessageView;
import org.nakedobjects.nos.client.dnd.view.message.MessageContent;

public class DetailedMessageViewSpecification
implements ViewSpecification {
    public boolean canDisplay(Content content) {
        return content instanceof MessageContent && ((MessageContent)content).getDetail() != null;
    }

    public String getName() {
        return "Detailed Message";
    }

    public View createView(Content content, ViewAxis axis) {
        ButtonAction[] actions = new ButtonAction[]{new AbstractButtonAction("Print..."){

            public void execute(Workspace workspace, View view, Location at) {
                DebugOutput.print((String)"Print exception", (String)DetailedMessageViewSpecification.this.extract(view));
            }
        }, new AbstractButtonAction("Save..."){

            public void execute(Workspace workspace, View view, Location at) {
                DebugOutput.saveToFile((String)"Save exception", (String)"Exception", (String)DetailedMessageViewSpecification.this.extract(view));
            }
        }, new AbstractButtonAction("Copy"){

            public void execute(Workspace workspace, View view, Location at) {
                DebugOutput.saveToClipboard((String)DetailedMessageViewSpecification.this.extract(view));
            }
        }, new CancelAction()};
        return new DialogBorder(new ButtonBorder(actions, new ScrollBorder(new DetailedMessageView(content, this, null))), false);
    }

    private String extract(View view) {
        Content content = view.getContent();
        String message = ((MessageContent)content).getMessage();
        String heading = ((MessageContent)content).title();
        String detail = ((MessageContent)content).getDetail();
        StringBuffer text = new StringBuffer();
        text.append(heading);
        text.append("\n\n");
        text.append(message);
        text.append("\n\n");
        text.append(detail);
        text.append("\n\n");
        return text.toString();
    }

    public boolean isAligned() {
        return false;
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReplaceable() {
        return false;
    }

    public boolean isSubView() {
        return false;
    }
}

