/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.message;

import org.nakedobjects.noa.NakedObjectApplicationException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.persist.ConcurrencyException;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.ExceptionHelper;
import org.nakedobjects.nof.core.util.NameConvertor;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.drawing.Image;
import org.nakedobjects.nos.client.dnd.view.message.MessageContent;

public class ExceptionMessageContent
implements MessageContent {
    protected String message;
    protected String name;
    protected String trace;
    protected String title;
    private final String icon;

    public ExceptionMessageContent(Throwable error) {
        String fullName = error.getClass().getName();
        fullName = fullName.substring(fullName.lastIndexOf(46) + 1);
        this.name = NameConvertor.naturalName((String)fullName);
        this.message = error.getMessage();
        this.trace = ExceptionHelper.exceptionTraceAsString((Throwable)error);
        if (this.trace.indexOf("\tat") != -1) {
            this.trace = this.trace.substring(this.trace.indexOf("\tat"));
        }
        if (this.name == null) {
            this.name = "";
        }
        if (this.message == null) {
            this.message = "";
        }
        if (this.trace == null) {
            this.trace = "";
        }
        if (error instanceof NakedObjectApplicationException) {
            this.title = "Application Error";
            this.icon = "application-error";
        } else if (error instanceof ConcurrencyException) {
            this.title = "Concurrency Error";
            this.icon = "concurrency-error";
        } else {
            this.title = "System Error";
            this.icon = "system-error";
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetail() {
        return this.trace;
    }

    public String getIconName() {
        return this.icon;
    }

    public Consent canDrop(Content sourceContent) {
        return Veto.DEFAULT;
    }

    public void contentMenuOptions(UserActionSet options) {
    }

    public void debugDetails(DebugString debug) {
    }

    public Naked drop(Content sourceContent) {
        return null;
    }

    public String getDescription() {
        return this.name;
    }

    public String getHelp() {
        return "";
    }

    public Image getIconPicture(int iconHeight) {
        return null;
    }

    public String getId() {
        return "message-exception";
    }

    public Naked getNaked() {
        return null;
    }

    public Naked[] getOptions() {
        return null;
    }

    public NakedObjectSpecification getSpecification() {
        return null;
    }

    public boolean isCollection() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public boolean isPersistable() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isValue() {
        return false;
    }

    public void parseTextEntry(String entryText) {
    }

    public String title() {
        return this.name;
    }

    public void viewMenuOptions(UserActionSet options) {
    }

    public String windowTitle() {
        return this.title;
    }
}

