/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.simple;

import java.util.Enumeration;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.nof.core.reflect.Allow;
import org.nakedobjects.nof.core.reflect.Veto;
import org.nakedobjects.nof.core.undo.UndoStack;
import org.nakedobjects.nof.core.util.Assert;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nof.core.util.UnexpectedCallException;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Feedback;
import org.nakedobjects.nos.client.dnd.FocusManager;
import org.nakedobjects.nos.client.dnd.InternalDrag;
import org.nakedobjects.nos.client.dnd.KeyboardAction;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.Viewer;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.action.CloseAllViewsForObjectOption;
import org.nakedobjects.nos.client.dnd.action.CloseAllViewsOption;
import org.nakedobjects.nos.client.dnd.action.CloseViewOption;
import org.nakedobjects.nos.client.dnd.action.OpenViewOption;
import org.nakedobjects.nos.client.dnd.action.ReplaceViewOption;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Padding;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.simple.NonBuildingSpecification;

public abstract class AbstractView
implements View {
    private static final UserAction CLOSE_ALL_OPTION = new CloseAllViewsOption();
    private static final UserAction CLOSE_OPTION = new CloseViewOption();
    private static final UserAction CLOSE_VIEWS_FOR_OBJECT = new CloseAllViewsForObjectOption();
    private static final Logger LOG = Logger.getLogger(AbstractView.class);
    private static int nextId = 0;
    private Content content;
    private int height;
    private int id = 0;
    private View parent;
    private ViewSpecification specification;
    private ViewState state;
    private View view;
    private ViewAxis viewAxis;
    private int width;
    private int x;
    private int y;

    protected AbstractView() {
        this(null, null, null);
    }

    protected AbstractView(Content content, ViewSpecification specification, ViewAxis axis) {
        this.assignId();
        this.content = content;
        this.specification = specification;
        this.viewAxis = axis;
        this.state = new ViewState();
        this.view = this;
    }

    public void addView(View view) {
        throw new NakedObjectRuntimeException("Can't add views to " + this);
    }

    protected void assignId() {
        this.id = nextId++;
    }

    public Consent canChangeValue() {
        return Veto.DEFAULT;
    }

    public boolean canFocus() {
        return true;
    }

    public boolean contains(View view) {
        View[] subviews = this.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            if (subviews[i] != view && (subviews[i] == null || !subviews[i].contains(view))) continue;
            return true;
        }
        return false;
    }

    public boolean containsFocus() {
        if (this.hasFocus()) {
            return true;
        }
        View[] subviews = this.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            if (subviews[i] == null || !subviews[i].containsFocus()) continue;
            return true;
        }
        return false;
    }

    public void contentMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("background.content-menu"));
        Content content = this.getContent();
        if (content != null) {
            content.contentMenuOptions(options);
        }
    }

    public void debug(DebugString debug) {
        View p;
        String name = this.getClass().getName();
        debug.appendln("Root", (Object)(name.substring(name.lastIndexOf(46) + 1) + this.getId()));
        debug.indent();
        debug.appendln("set size", (Object)this.getSize());
        debug.appendln("maximum", (Object)this.getMaximumSize());
        debug.appendln("required", (Object)this.getRequiredSize(new Size()));
        debug.appendln("w/in parent", (Object)this.getRequiredSize(this.getParent() == null ? new Size() : this.getParent().getSize()));
        debug.appendln("parent's", (Object)((this.getParent() == null ? new Size() : this.getParent().getSize()) + ")"));
        debug.appendln("padding", (Object)this.getPadding());
        debug.appendln("base line", (Object)(this.getBaseline() + "px"));
        debug.unindent();
        debug.appendln();
        debug.appendTitle("Specification");
        if (this.specification == null) {
            debug.append((Object)"\none");
        } else {
            debug.appendln(this.specification.getName());
            debug.appendln("  " + this.specification.getClass().getName());
            debug.appendln("  " + (this.specification.isOpen() ? "open" : "closed"));
            debug.appendln("  " + (this.specification.isReplaceable() ? "replaceable" : "non-replaceable"));
            debug.appendln("  " + (this.specification.isSubView() ? "subview" : "main view"));
        }
        debug.appendln();
        debug.appendTitle("View");
        debug.appendln("Changable", (Object)this.canChangeValue());
        debug.appendln();
        debug.appendln("Focus", (Object)(this.canFocus() ? "focusable" : "non-focusable"));
        debug.appendln("Has", this.hasFocus());
        debug.appendln("Contains focus", this.containsFocus());
        debug.appendln("Focus manager", (Object)this.getFocusManager());
        debug.appendln();
        debug.appendln("Self", (Object)this.getView());
        debug.appendln("Axis", (Object)this.getViewAxis());
        debug.appendln("State", (Object)this.getState());
        debug.appendln("Location", (Object)this.getLocation());
        String parent = p == null ? "none" : "" + p;
        debug.appendln("Parent", (Object)parent);
        debug.indent();
        for (p = this.getParent(); p != null; p = p.getParent()) {
            debug.appendln(p.toString());
        }
        debug.unindent();
        debug.appendln("Workspace", (Object)this.getWorkspace());
        debug.appendln();
        debug.appendln();
        debug.appendln();
        debug.appendTitle("View structure");
        this.debugStructure(debug);
    }

    public void debugStructure(DebugString b) {
        b.appendln(this.getSpecification().getName());
        b.indent();
        b.appendln("Content", this.getContent() == null ? null : this.getContent().getId());
        b.appendln("Required size ", (Object)this.getRequiredSize(new Size()));
        b.appendln("Bounds", (Object)this.getBounds());
        b.appendln("Baseline", (long)this.getBaseline());
        View[] views = this.getSubviews();
        b.indent();
        for (int i = 0; i < views.length; ++i) {
            View subview = views[i];
            subview.debugStructure(b);
            b.unindent();
        }
        b.unindent();
    }

    public void dispose() {
        if (this.parent != null) {
            this.parent.removeView(this.getView());
        }
    }

    public void drag(InternalDrag drag) {
    }

    public void drag(ContentDrag contentDrag) {
    }

    public void dragCancel(InternalDrag drag) {
        this.getFeedbackManager().showDefaultCursor();
    }

    public View dragFrom(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            return subview.dragFrom(location);
        }
        return null;
    }

    public void dragIn(ContentDrag drag) {
    }

    public void dragOut(ContentDrag drag) {
    }

    public Drag dragStart(DragStart drag) {
        View subview = this.subviewFor(drag.getLocation());
        if (subview != null) {
            drag.subtract(subview.getLocation());
            return subview.dragStart(drag);
        }
        return null;
    }

    public void dragTo(InternalDrag drag) {
    }

    public void draw(Canvas canvas) {
        if (Toolkit.debug) {
            canvas.drawDebugOutline(new Bounds(this.getSize()), this.getBaseline(), Toolkit.getColor("debug.bounds.view"));
        }
    }

    public void drop(ContentDrag drag) {
    }

    public void drop(ViewDrag drag) {
    }

    public void editComplete() {
    }

    public void entered() {
        String description;
        Content cont = this.getContent();
        if (cont != null && (description = cont.getDescription()) != null && !"".equals(description)) {
            this.getFeedbackManager().setViewDetail(description);
        }
    }

    public void exited() {
    }

    public void firstClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.firstClick(click);
        }
    }

    public void focusLost() {
    }

    public void focusReceived() {
    }

    public Location getAbsoluteLocation() {
        if (this.parent == null) {
            return this.getLocation();
        }
        Location location = this.parent.getAbsoluteLocation();
        this.getViewManager().getSpy().addTrace(this, "parent location", location);
        location.add(this.x, this.y);
        this.getViewManager().getSpy().addTrace(this, "plus view's location", location);
        Padding pad = this.parent.getPadding();
        location.add(pad.getLeft(), pad.getTop());
        this.getViewManager().getSpy().addTrace(this, "plus view's padding", location);
        return location;
    }

    public int getBaseline() {
        return 0;
    }

    public Bounds getBounds() {
        return new Bounds(this.x, this.y, this.width, this.height);
    }

    public Content getContent() {
        return this.content;
    }

    public FocusManager getFocusManager() {
        return this.getParent() == null ? null : this.getParent().getFocusManager();
    }

    public int getId() {
        return this.id;
    }

    public Location getLocation() {
        return new Location(this.x, this.y);
    }

    public Padding getPadding() {
        return new Padding(0, 0, 0, 0);
    }

    public final View getParent() {
        Assert.assertEquals((Object)(this.parent == null ? null : this.parent.getView()), (Object)this.parent);
        return this.parent;
    }

    public Size getRequiredSize(Size maximumSize) {
        return this.getMaximumSize();
    }

    public Size getMaximumSize() {
        return new Size();
    }

    public Size getSize() {
        return new Size(this.width, this.height);
    }

    public ViewSpecification getSpecification() {
        if (this.specification == null) {
            this.specification = new NonBuildingSpecification(this);
        }
        return this.specification;
    }

    public ViewState getState() {
        return this.state;
    }

    public View[] getSubviews() {
        return new View[0];
    }

    public final View getView() {
        return this.view;
    }

    public final ViewAxis getViewAxis() {
        return this.viewAxis;
    }

    public Viewer getViewManager() {
        return Toolkit.getViewer();
    }

    public Feedback getFeedbackManager() {
        return Toolkit.getFeedbackManager();
    }

    public Workspace getWorkspace() {
        return this.getParent() == null ? null : this.getParent().getWorkspace();
    }

    public boolean hasFocus() {
        return this.getViewManager().hasFocus(this.getView());
    }

    public View identify(Location location) {
        View subview = this.subviewFor(location);
        if (subview == null) {
            this.getViewManager().getSpy().addTrace(this, "mouse location within node view", location);
            this.getViewManager().getSpy().addTrace("----");
            return this.getView();
        }
        location.subtract(subview.getLocation());
        return subview.identify(location);
    }

    public void invalidateContent() {
    }

    public void invalidateLayout() {
        if (this.parent != null) {
            this.parent.invalidateLayout();
        }
    }

    public void keyPressed(KeyboardAction key) {
    }

    public void keyReleased(int keyCode, int modifiers) {
    }

    public void keyTyped(char keyCode) {
    }

    public void layout(Size maximumSize) {
    }

    public void limitBoundsWithin(Bounds containerBounds) {
        Bounds contentBounds = this.getView().getBounds();
        if (containerBounds.limitBounds(contentBounds)) {
            this.getView().setBounds(contentBounds);
        }
    }

    public void limitBoundsWithin(Size size) {
        int w = this.getView().getSize().getWidth();
        int h = this.getView().getSize().getHeight();
        int x = this.getView().getLocation().getX();
        int y = this.getView().getLocation().getY();
        if (x + w > size.getWidth()) {
            x = size.getWidth() - w;
        }
        if (x < 0) {
            x = 0;
        }
        if (y + h > size.getHeight()) {
            y = size.getHeight() - h;
        }
        if (y < 0) {
            y = 0;
        }
        this.getView().setLocation(new Location(x, y));
    }

    public void markDamaged() {
        this.markDamaged(this.getView().getBounds());
    }

    public void markDamaged(Bounds bounds) {
        if (this.parent == null) {
            this.getViewManager().markDamaged(bounds);
        } else {
            Location pos = this.parent.getLocation();
            bounds.translate(pos.getX(), pos.getY());
            Padding pad = this.parent.getPadding();
            bounds.translate(pad.getLeft(), pad.getTop());
            this.parent.markDamaged(bounds);
        }
    }

    public void mouseDown(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.mouseDown(click);
        }
    }

    public void mouseMoved(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            subview.mouseMoved(location);
        }
    }

    public void mouseUp(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.mouseUp(click);
        }
    }

    public void objectActionResult(Naked result, Location at) {
        this.getWorkspace().addOpenViewFor(result, at);
    }

    public View pickupContent(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            return subview.pickupView(location);
        }
        return Toolkit.getViewFactory().createDragViewOutline(this.getView());
    }

    public View pickupView(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            return subview.pickupView(location);
        }
        return null;
    }

    public void print(Canvas canvas) {
        this.draw(canvas);
    }

    public void refresh() {
    }

    public void removeView(View view) {
        throw new NakedObjectRuntimeException();
    }

    protected void replaceOptions(Enumeration possibleViews, UserActionSet options) {
        while (possibleViews.hasMoreElements()) {
            ViewSpecification specification = (ViewSpecification)possibleViews.nextElement();
            if (specification == this.getSpecification() || this.view.getParent() != this.view.getWorkspace() || this.view.getClass() == this.getClass()) continue;
            ReplaceViewOption viewAs = new ReplaceViewOption(specification);
            options.add(viewAs);
        }
    }

    public void replaceView(View toReplace, View replacement) {
        throw new NakedObjectRuntimeException();
    }

    public void secondClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.secondClick(click);
        }
    }

    public void setBounds(Bounds bounds) {
        this.x = bounds.getX();
        this.y = bounds.getY();
        this.width = bounds.getWidth();
        this.height = bounds.getHeight();
    }

    public void setFocusManager(FocusManager focusManager) {
        throw new UnexpectedCallException();
    }

    protected void setContent(Content content) {
        this.content = content;
    }

    public void setLocation(Location location) {
        this.x = location.getX();
        this.y = location.getY();
    }

    public final void setParent(View parentView) {
        LOG.debug((Object)("set parent " + this.parent + " for " + this));
        this.parent = parentView.getView();
    }

    public void setMaximumSize(Size size) {
    }

    public void setSize(Size size) {
        this.width = size.getWidth();
        this.height = size.getHeight();
    }

    protected void setSpecification(ViewSpecification specification) {
        this.specification = specification;
    }

    public final void setView(View view) {
        this.view = view;
    }

    protected void setViewAxis(ViewAxis viewAxis) {
        this.viewAxis = viewAxis;
    }

    public View subviewFor(Location location) {
        return null;
    }

    public void thirdClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.thirdClick(click);
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1) + this.getId() + ":" + this.getState() + ":" + this.getContent();
    }

    public void update(Naked object) {
    }

    public void updateView() {
    }

    public ViewAreaType viewAreaType(Location location) {
        View subview = this.subviewFor(location);
        if (subview != null) {
            location.subtract(subview.getLocation());
            return subview.viewAreaType(location);
        }
        return ViewAreaType.CONTENT;
    }

    public void viewMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("background.view-menu"));
        Content content = this.getContent();
        if (content != null) {
            content.viewMenuOptions(options);
        }
        if (this.getParent() != null) {
            Enumeration possibleViews = Toolkit.getViewFactory().openRootViews(content, null);
            while (possibleViews.hasMoreElements()) {
                ViewSpecification specification = (ViewSpecification)possibleViews.nextElement();
                OpenViewOption viewAs = new OpenViewOption(specification);
                options.add(viewAs);
            }
        }
        if (this.view.getSpecification() != null && this.view.getSpecification().isSubView()) {
            if (this.view.getSpecification().isReplaceable()) {
                this.replaceOptions(Toolkit.getViewFactory().openSubviews(content, this), options);
                this.replaceOptions(Toolkit.getViewFactory().closedSubviews(content, this), options);
            }
        } else {
            if (this.view.getSpecification() != null && this.view.getSpecification().isReplaceable()) {
                this.replaceOptions(Toolkit.getViewFactory().openRootViews(content, this), options);
            }
            if (this.getParent() != null) {
                options.add(CLOSE_OPTION);
                options.add(CLOSE_ALL_OPTION);
                options.add(CLOSE_VIEWS_FOR_OBJECT);
            }
        }
        options.add(new AbstractUserAction("Refresh view", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                AbstractView.this.refresh();
            }
        });
        options.add(new AbstractUserAction("Invalidate content", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                AbstractView.this.invalidateContent();
            }
        });
        options.add(new AbstractUserAction("Invalidate layout", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                AbstractView.this.invalidateLayout();
            }
        });
        final UndoStack undoStack = this.getViewManager().getUndoStack();
        if (!undoStack.isEmpty()) {
            options.add(new AbstractUserAction("Undo " + undoStack.getNameOfUndo()){

                public Consent disabled(View component) {
                    return new Allow(undoStack.descriptionOfUndo());
                }

                public void execute(Workspace workspace, View view, Location at) {
                    undoStack.undoLastCommand();
                }
            });
        }
    }
}

