/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.simple;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.ObjectView;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;
import org.nakedobjects.nos.client.dnd.view.text.TitleText;

public class Icon
extends ObjectView {
    private IconGraphic icon;
    private boolean isVertical;
    private IconGraphic selectedGraphic;
    private TitleText title;
    private IconGraphic unselectedGraphic;

    public Icon(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.ensureHasIcon();
        int x = 0;
        int y = 0;
        this.icon.draw(canvas, x, 0);
        if (this.isVertical) {
            int w = this.title.getSize().getWidth();
            x = w > this.icon.getSize().getWidth() ? x : this.getSize().getWidth() / 2 - w / 2;
            y = this.icon.getSize().getHeight() + Toolkit.getText("large-icon").getAscent() + VPADDING;
        } else {
            x += this.icon.getSize().getWidth();
            x += View.HPADDING;
            y = this.icon.getBaseline();
        }
        this.title.draw(canvas, x, y);
    }

    private void ensureHasIcon() {
        if (this.icon == null) {
            this.icon = this.selectedGraphic;
        }
    }

    public void entered() {
        this.icon = this.selectedGraphic;
        this.markDamaged();
        super.entered();
    }

    public void exited() {
        this.icon = this.unselectedGraphic;
        this.markDamaged();
        super.exited();
    }

    public int getBaseline() {
        this.ensureHasIcon();
        return this.icon.getBaseline();
    }

    public Size getMaximumSize() {
        if (this.icon == null) {
            this.icon = this.selectedGraphic;
        }
        Size size = this.icon.getSize();
        Size textSize = this.title.getSize();
        if (this.isVertical) {
            size.extendHeight(VPADDING + textSize.getHeight() + VPADDING);
            size.ensureWidth(textSize.getWidth());
        } else {
            size.extendWidth(View.HPADDING);
            size.extendWidth(textSize.getWidth());
        }
        return size;
    }

    public void setSelectedIcon(IconGraphic selectedGraphic) {
        this.selectedGraphic = selectedGraphic;
    }

    public void setTitle(ObjectTitleText text) {
        this.title = text;
    }

    public void setUnselectedGraphic(IconGraphic unselectedGraphic) {
        this.unselectedGraphic = unselectedGraphic;
    }

    public void setVertical(boolean isVertical) {
        this.isVertical = isVertical;
    }

    public void update(Naked object) {
        View p = this.getParent();
        if (p != null) {
            p.invalidateLayout();
        }
    }
}

