/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.simple;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.reflect.Consent;
import org.nakedobjects.noa.reflect.NakedObjectAction;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewDrag;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Offset;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;
import org.nakedobjects.nos.client.dnd.view.simple.DragViewOutline;

public abstract class ObjectView
extends AbstractView {
    public ObjectView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void dragIn(ContentDrag drag) {
        Consent perm = this.getContent().canDrop(drag.getSourceContent());
        String description = this.getContent().getDescription();
        this.getFeedbackManager().setAction(perm.getReason() + " " + description);
        if (perm.isAllowed()) {
            this.getState().setCanDrop();
        } else {
            this.getState().setCantDrop();
        }
        this.markDamaged();
    }

    public void dragOut(ContentDrag drag) {
        this.getState().clearObjectIdentified();
        this.markDamaged();
    }

    public Drag dragStart(DragStart drag) {
        View subview = this.subviewFor(drag.getLocation());
        if (subview != null) {
            drag.subtract(subview.getLocation());
            return subview.dragStart(drag);
        }
        if (drag.isCtrl()) {
            DragViewOutline dragOverlay = new DragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(drag.getLocation()), dragOverlay);
        }
        View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(this.getContent(), null);
        return new ContentDrag(this, drag.getLocation(), dragOverlay);
    }

    public void drop(ContentDrag drag) {
        Naked result = this.getContent().drop(drag.getSourceContent());
        if (result != null) {
            View view = this.getWorkspace().createSubviewFor(result, false);
            Location location = new Location();
            location.move(10, 10);
            view.setLocation(location);
            this.getWorkspace().addView(view);
        }
        this.getState().clearObjectIdentified();
        this.getFeedbackManager().showMessagesAndWarnings();
        this.markDamaged();
    }

    public void firstClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.firstClick(click);
        } else if (click.button2()) {
            ViewSpecification spec = Toolkit.getViewFactory().getOverlayViewSpecification(this.getContent());
            View view = spec.createView(this.getContent(), null);
            Size size = view.getMaximumSize();
            Location location = new Location(click.getLocationWithinViewer());
            location.subtract(size.getWidth() / 2, size.getHeight() / 2);
            this.getViewManager().setOverlayView(view);
        }
    }

    public void invalidateContent() {
        super.invalidateLayout();
    }

    public void secondClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            click.subtract(subview.getLocation());
            subview.secondClick(click);
        } else {
            Location location = this.getAbsoluteLocation();
            location.translate(click.getLocation());
            View openWindow = Toolkit.getViewFactory().createWindow(this.getContent());
            openWindow.setLocation(location);
            this.getWorkspace().addView(openWindow);
        }
    }

    public String toString() {
        return super.toString() + ": " + this.getContent();
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        options.add(new AbstractUserAction("Reload", NakedObjectAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                NakedObject object = (NakedObject)ObjectView.this.getContent().getNaked();
                NakedObjectsContext.getObjectPersistor().reload(object);
            }
        });
    }

    public void viewMenuOptions(UserActionSet options) {
        super.viewMenuOptions(options);
        options.add(new AbstractUserAction("Reload View", UserAction.EXPLORATION){

            public void execute(Workspace workspace, View view, Location at) {
                ObjectView.this.invalidateContent();
            }
        });
    }
}

