/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.simple;

import org.nakedobjects.noa.adapter.Naked;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.view.simple.AbstractView;

public class TextView
extends AbstractView {
    private Text style = Toolkit.getText("normal");
    private Color color = Toolkit.getColor("black");
    private String text;

    public TextView(String text) {
        super(null, null, null);
        this.text = text;
    }

    public TextView(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
        Naked object = content.getNaked();
        this.text = object == null ? "" : object.titleString();
    }

    public TextView(String text, ViewAxis axis) {
        super(null, null, null);
        this.text = text;
    }

    public boolean canFocus() {
        return false;
    }

    public void draw(Canvas canvas) {
        canvas.drawText(this.text, HPADDING, this.getBaseline(), this.color, this.style);
    }

    public int getBaseline() {
        return this.style.getAscent() + VPADDING;
    }

    public Size getRequiredSize(Size maximumSize) {
        int width = this.style.stringWidth(this.text) + HPADDING * 2;
        int height = this.style.getTextHeight() + VPADDING * 2;
        return new Size(width, height);
    }
}

