/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.specification;

import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.adapter.NakedReference;
import org.nakedobjects.noa.reflect.OneToManyAssociation;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ContentDrag;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.CloseViewOption;
import org.nakedobjects.nos.client.dnd.content.OptionFactory;
import org.nakedobjects.nos.client.dnd.content.ServiceObject;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.view.graphic.IconGraphic;
import org.nakedobjects.nos.client.dnd.view.simple.Icon;
import org.nakedobjects.nos.client.dnd.view.text.ObjectTitleText;

public class ServiceIcon
extends Icon {
    private static final int ICON_SIZE;
    private static final int LARGE_ICON_SIZE = 34;
    private static final String LARGE_ICON_SIZE_PROPERTY;

    public ServiceIcon(Content content, ViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
        this.setTitle(new ObjectTitleText(this, Toolkit.getText("large-icon")));
        this.setSelectedIcon(new IconGraphic((View)this, ICON_SIZE));
        this.setVertical(true);
    }

    public void contentMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("background.content-menu"));
        OptionFactory.addObjectMenuOptions((NakedReference)this.getContent().getNaked(), options);
    }

    public void viewMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("background.view-menu"));
        options.add(new CloseViewOption(){

            public void execute(Workspace workspace, View view, Location at) {
                ObjectContent parent = (ObjectContent)view.getParent().getContent();
                NakedObject perspective = parent.getObject();
                OneToManyAssociation fld = (OneToManyAssociation)perspective.getSpecification().getField("services");
                ServiceObject service = (ServiceObject)view.getContent();
                NakedObject element = service.getObject();
                fld.removeElement(perspective, element);
                super.execute(workspace, view, at);
            }
        });
    }

    public Drag dragStart(DragStart drag) {
        View dragOverlay = Toolkit.getViewFactory().getContentDragSpecification().createView(this.getContent(), null);
        return new ContentDrag(this, drag.getLocation(), dragOverlay);
    }

    static {
        LARGE_ICON_SIZE_PROPERTY = "nakedobjects.viewer.dnd.large-icon-size";
        ICON_SIZE = NakedObjectsContext.getConfiguration().getInteger(LARGE_ICON_SIZE_PROPERTY, 34);
    }
}

