/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.view.text;

import org.nakedobjects.noa.adapter.ResolveException;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewState;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.drawing.Text;

public abstract class TitleText {
    private static final int NO_MAX_WIDTH = -1;
    private final int ellipsisWidth;
    private final Color color;
    private final Text style;
    private final View view;
    private boolean resolveFailure;

    public TitleText(View view, Text style, Color color) {
        this.view = view;
        this.style = style;
        this.color = color;
        this.ellipsisWidth = style.stringWidth("...");
    }

    public void draw(Canvas canvas, int x, int baseline) {
        this.draw(canvas, x, baseline, -1);
    }

    public void draw(Canvas canvas, int x, int baseline, int maxWidth) {
        ViewState state = this.view.getState();
        Color color = this.resolveFailure ? Toolkit.getColor("error") : (state.canDrop() ? Toolkit.getColor("valid") : (state.cantDrop() ? Toolkit.getColor("invalid") : (state.isObjectIdentified() ? Toolkit.getColor("primary1") : this.color)));
        int xt = x;
        int yt = baseline;
        String text = this.getTitle();
        if (maxWidth > 0 && this.style.stringWidth(text) > maxWidth) {
            char character;
            int lastCharacterWithinAllowedWidth = 0;
            int textWidth = this.ellipsisWidth;
            while (textWidth <= maxWidth) {
                character = text.charAt(lastCharacterWithinAllowedWidth);
                textWidth += this.style.charWidth(character);
                ++lastCharacterWithinAllowedWidth;
            }
            int space = text.lastIndexOf(32, lastCharacterWithinAllowedWidth - 1);
            if (space > 0) {
                while (space >= 0 && !Character.isLetterOrDigit(character = text.charAt(space - 1))) {
                    --space;
                }
                text = text.substring(0, space);
            } else {
                text = text.substring(0, lastCharacterWithinAllowedWidth - 1);
            }
            text = text + "...";
        }
        if (Toolkit.debug) {
            int x2 = this.style.stringWidth(text);
            canvas.drawDebugOutline(new Bounds(xt, yt - this.style.getAscent(), x2, this.style.getTextHeight()), baseline, Toolkit.getColor("debug.bounds.draw"));
        }
        canvas.drawText(text, xt, yt, color, this.style);
    }

    public Size getSize() {
        int height = this.style.getTextHeight();
        int width = this.style.stringWidth(this.getTitle());
        return new Size(width, height);
    }

    private String getTitle() {
        String title;
        if (this.resolveFailure) {
            return "Resolve Failure!";
        }
        try {
            title = this.title();
        }
        catch (ResolveException e) {
            this.resolveFailure = true;
            title = "Resolve Failure!";
        }
        return title;
    }

    protected abstract String title();

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("style", (Object)this.style);
        str.append("color", (Object)this.color);
        return str.toString();
    }
}

