/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.viewer;

import java.util.Hashtable;
import org.nakedobjects.nos.client.dnd.ColorsAndFonts;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.drawing.Color;
import org.nakedobjects.nos.client.dnd.drawing.Text;
import org.nakedobjects.nos.client.dnd.viewer.AwtColor;
import org.nakedobjects.nos.client.dnd.viewer.AwtText;

public class AwtColorsAndFonts
implements ColorsAndFonts {
    private Hashtable colors = new Hashtable();
    private int defaultBaseline;
    private int defaultFieldHeight;
    private Hashtable fonts = new Hashtable();

    public int defaultBaseline() {
        if (this.defaultBaseline == 0) {
            int iconSize = this.getText("normal").getAscent();
            this.defaultBaseline = View.VPADDING + iconSize;
        }
        return this.defaultBaseline;
    }

    public int defaultFieldHeight() {
        if (this.defaultFieldHeight == 0) {
            this.defaultFieldHeight = this.getText("normal").getTextHeight();
        }
        return this.defaultFieldHeight;
    }

    public Color getColor(String name) {
        Color color = (Color)this.colors.get(name);
        if (color == null && name.startsWith("background.window.")) {
            color = new AwtColor(name, (AwtColor)this.getColor("background.window"));
            this.colors.put(name, color);
        }
        return color;
    }

    public Color getColor(int rgbColor) {
        return new AwtColor(rgbColor);
    }

    public Text getText(String name) {
        return (Text)this.fonts.get(name);
    }

    public void init() {
        this.setColor("black", "#000000");
        this.setColor("white", "#ffffff");
        this.setColor("primary1", "#666699");
        this.setColor("primary2", "#9999cc");
        this.setColor("primary3", "#ccccff");
        this.setColor("secondary1", "#666666");
        this.setColor("secondary2", "#999999");
        this.setColor("secondary3", "#cccccc");
        this.setColor("background.application", "#e0e0e0");
        this.setColor("background.window", this.getColor("white"));
        this.setColor("background.value-menu", this.getColor("primary3"));
        this.setColor("background.content-menu", this.getColor("primary3"));
        this.setColor("background.view-menu", this.getColor("secondary3"));
        this.setColor("background.workspace-menu", this.getColor("secondary3"));
        this.setColor("menu.normal", this.getColor("black"));
        this.setColor("menu.disabled", this.getColor("secondary1"));
        this.setColor("menu.reversed", this.getColor("white"));
        this.setColor("identified", this.getColor("primary3"));
        this.setColor("valid", "#32CD32");
        this.setColor("invalid", "#ee1919");
        this.setColor("error", "#ee1919");
        this.setColor("active", "#ff0000");
        this.setColor("out-of-sync", "#662200");
        this.setColor("text.saved", this.getColor("secondary1"));
        this.setColor("text.edit", this.getColor("primary1"));
        this.setColor("text.cursor", this.getColor("primary1"));
        this.setColor("text.highlight", this.getColor("primary3"));
        this.setColor("debug.baseline", AwtColor.DEBUG_BASELINE);
        this.setColor("debug.bounds.border", AwtColor.DEBUG_BORDER_BOUNDS);
        this.setColor("debug.bounds.draw", AwtColor.DEBUG_DRAW_BOUNDS);
        this.setColor("debug.bounds.repaint", AwtColor.DEBUG_REPAINT_BOUNDS);
        this.setColor("debug.bounds.view", AwtColor.DEBUG_VIEW_BOUNDS);
        this.setText("control", "SansSerif-bold-12");
        this.setText("title", "SansSerif-bold-12");
        this.setText("small-title", "SansSerif-bold-12");
        this.setText("status", "SansSerif--12");
        this.setText("large-icon", "SansSerif-bold-12");
        this.setText("mandatory-label", "SansSerif-bold-11");
        this.setText("label", "SansSerif--11");
        this.setText("menu", "SansSerif--12");
        this.setText("normal", "SansSerif-plain-12");
    }

    private void setColor(String name, Color defaultColor) {
        this.setColor(name, (AwtColor)defaultColor);
    }

    private void setColor(String name, AwtColor defaultColor) {
        if (this.getColor(name) == null) {
            AwtColor color = new AwtColor(name, defaultColor);
            this.colors.put(name, color);
        }
    }

    private void setColor(String name, String defaultColor) {
        if (this.getColor(name) == null) {
            AwtColor color = new AwtColor(name, defaultColor);
            this.colors.put(name, color);
        }
    }

    private void setText(String name, String defaultFont) {
        if (this.getText(name) == null) {
            AwtText font = new AwtText(name, defaultFont);
            this.fonts.put(name, font);
        }
    }
}

