/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.viewer;

import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.util.DebugInfo;
import org.nakedobjects.nof.core.util.InfoDebugFrame;
import org.nakedobjects.nos.client.dnd.MenuOptions;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserAction;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.Workspace;
import org.nakedobjects.nos.client.dnd.action.AbstractUserAction;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.viewer.OverlayDebugFrame;
import org.nakedobjects.nos.client.dnd.viewer.XViewer;

public class DebugOptions
implements MenuOptions {
    private final XViewer viewer;

    public DebugOptions(XViewer viewer) {
        this.viewer = viewer;
    }

    public void menuOptions(UserActionSet options) {
        String showExplorationMenu = "Always show exploration menu " + (this.viewer.showExplorationMenuByDefault ? "off" : "on");
        options.add(new AbstractUserAction(showExplorationMenu, UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                ((DebugOptions)DebugOptions.this).viewer.showExplorationMenuByDefault = !((DebugOptions)DebugOptions.this).viewer.showExplorationMenuByDefault;
                view.markDamaged();
            }
        });
        String repaint = "Show painting area  " + (this.viewer.showRepaintArea ? "off" : "on");
        options.add(new AbstractUserAction(repaint, UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                ((DebugOptions)DebugOptions.this).viewer.showRepaintArea = !((DebugOptions)DebugOptions.this).viewer.showRepaintArea;
                view.markDamaged();
            }
        });
        String debug = "Debug graphics " + (Toolkit.debug ? "off" : "on");
        options.add(new AbstractUserAction(debug, UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                Toolkit.debug = !Toolkit.debug;
                view.markDamaged();
            }
        });
        String action = this.viewer.isShowingMouseSpy() ? "Hide" : "Show";
        options.add(new AbstractUserAction(action + " mouse spy", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                DebugOptions.this.viewer.setShowMouseSpy(!DebugOptions.this.viewer.isShowingMouseSpy());
            }
        });
        options.add(new AbstractUserAction("Restart object loader/persistor", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                NakedObjectsContext.getObjectPersistor().reset();
                NakedObjectsContext.getObjectLoader().reset();
            }
        });
        options.add(new AbstractUserAction("Debug system...", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                InfoDebugFrame f = new InfoDebugFrame();
                DebugInfo[] contextInfo = NakedObjectsContext.debug();
                DebugInfo[] info = new DebugInfo[contextInfo.length + 1];
                System.arraycopy(contextInfo, 0, info, 0, contextInfo.length);
                info[info.length - 1] = ((DebugOptions)DebugOptions.this).viewer.updateNotifier;
                f.setInfo(info);
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });
        options.add(new AbstractUserAction("Debug viewer...", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                InfoDebugFrame f = new InfoDebugFrame();
                f.setInfo(new DebugInfo[]{Toolkit.getViewFactory(), ((DebugOptions)DebugOptions.this).viewer.updateNotifier});
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });
        options.add(new AbstractUserAction("Debug overlay...", UserAction.DEBUG){

            public void execute(Workspace workspace, View view, Location at) {
                OverlayDebugFrame f = new OverlayDebugFrame(DebugOptions.this.viewer);
                f.show(at.getX() + 50, workspace.getBounds().getY() + 6);
            }
        });
    }
}

