/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.viewer;

import java.awt.Dimension;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.security.AuthenticationRequest;
import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nof.core.client.AbstractClient;
import org.nakedobjects.nof.core.conf.ConfigurationException;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.Perspective;
import org.nakedobjects.nof.core.security.PasswordAuthenticationRequest;
import org.nakedobjects.nof.core.system.InstanceCreationException;
import org.nakedobjects.nof.core.system.InstanceFactory;
import org.nakedobjects.nos.client.dnd.HelpViewer;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.basic.DragContentSpecification;
import org.nakedobjects.nos.client.dnd.basic.EmptyField;
import org.nakedobjects.nos.client.dnd.basic.InnerWorkspaceSpecification;
import org.nakedobjects.nos.client.dnd.basic.PasswordFieldSpecification;
import org.nakedobjects.nos.client.dnd.basic.RootIconSpecification;
import org.nakedobjects.nos.client.dnd.basic.RootWorkspaceSpecification;
import org.nakedobjects.nos.client.dnd.basic.SubviewIconSpecification;
import org.nakedobjects.nos.client.dnd.basic.TreeBrowserSpecification;
import org.nakedobjects.nos.client.dnd.basic.WrappedTextFieldSpecification;
import org.nakedobjects.nos.client.dnd.content.RootObject;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.image.ImageFactory;
import org.nakedobjects.nos.client.dnd.list.ListSpecification;
import org.nakedobjects.nos.client.dnd.notifier.ViewUpdateNotifier;
import org.nakedobjects.nos.client.dnd.table.WindowTableSpecification;
import org.nakedobjects.nos.client.dnd.util.Properties;
import org.nakedobjects.nos.client.dnd.view.field.CheckboxField;
import org.nakedobjects.nos.client.dnd.view.field.ColorField;
import org.nakedobjects.nos.client.dnd.view.field.ImageField;
import org.nakedobjects.nos.client.dnd.view.field.TextFieldSpecification;
import org.nakedobjects.nos.client.dnd.view.form.WindowFormSpecification;
import org.nakedobjects.nos.client.dnd.view.help.InternalHelpViewer;
import org.nakedobjects.nos.client.dnd.view.message.DetailedMessageViewSpecification;
import org.nakedobjects.nos.client.dnd.view.message.MessageDialogSpecification;
import org.nakedobjects.nos.client.dnd.view.specification.ServiceIconSpecification;
import org.nakedobjects.nos.client.dnd.viewer.AwtToolkit;
import org.nakedobjects.nos.client.dnd.viewer.LoginDialog;
import org.nakedobjects.nos.client.dnd.viewer.ShutdownListener;
import org.nakedobjects.nos.client.dnd.viewer.SkylarkViewFactory;
import org.nakedobjects.nos.client.dnd.viewer.ViewerFrame;
import org.nakedobjects.nos.client.dnd.viewer.XViewer;

class DndClient
extends AbstractClient {
    private static final Logger LOG = Logger.getLogger(DndClient.class);
    private static final String SPECIFICATION_BASE = "nakedobjects.viewer.dnd.specification.";
    private ViewUpdateNotifier updateNotifier;
    private ViewerFrame frame;
    private XViewer viewer;
    private ShutdownListener shutdownListener;
    private Bounds bounds;
    private HelpViewer helpViewer;
    private boolean acceptingLogIns = true;

    private Bounds calculateBounds(Dimension screenSize) {
        int maxWidth = screenSize.width;
        int maxHeight = screenSize.height;
        if (screenSize.width / screenSize.height >= 2) {
            int f = screenSize.width / screenSize.height;
            maxWidth = screenSize.width / f;
        }
        int width = maxWidth - 80;
        int height = maxHeight - 80;
        int x = 40;
        int y = 40;
        Size size = Properties.getSize("nakedobjects.viewer.dnd.initial.size", new Size(width, height));
        Location location = Properties.getLocation("nakedobjects.viewer.dnd.initial.location", new Location(x, y));
        return new Bounds(location, size);
    }

    private ViewSpecification loadSpecification(String name, Class cls) {
        String factoryName = NakedObjectsContext.getConfiguration().getString(SPECIFICATION_BASE + name);
        ViewSpecification spec = factoryName != null ? (ViewSpecification)InstanceFactory.createInstance((String)factoryName, ViewSpecification.class) : (ViewSpecification)InstanceFactory.createInstance((String)cls.getName(), ViewSpecification.class);
        return spec;
    }

    private synchronized void logOut() {
        LOG.info((Object)"user log out");
        Session session = NakedObjectsContext.getSession();
        this.sessionManager.closeSession(session);
        this.viewer.close();
        ((Object)((Object)this)).notify();
    }

    protected AuthenticationRequest promptForAuthenticationDetails() {
        LoginDialog dialog = new LoginDialog();
        dialog.show();
        if (dialog.login()) {
            dialog.hide();
            dialog.dispose();
            return new PasswordAuthenticationRequest(dialog.getUser(), dialog.getPassword());
        }
        dialog.hide();
        dialog.dispose();
        return null;
    }

    protected void quit() {
        LOG.info((Object)"user quit");
        this.acceptingLogIns = false;
        this.shutdown();
    }

    public synchronized void run() {
        new ImageFactory(NakedObjectsContext.getTemplateImageLoader());
        new AwtToolkit();
        this.setupViewFactory();
        this.setShutdownListener(new ShutdownListener(){

            public void logOut() {
                DndClient.this.logOut();
            }

            public void quit() {
                DndClient.this.logOut();
                DndClient.this.quit();
            }
        });
        this.updateNotifier = new ViewUpdateNotifier();
        if (this.updateNotifier == null) {
            throw new NullPointerException("No update notifier set for " + (Object)((Object)this));
        }
        if (this.shutdownListener == null) {
            throw new NullPointerException("No shutdown listener set for " + (Object)((Object)this));
        }
        while (this.acceptingLogIns) {
            if (this.login()) {
                this.openViewer();
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            this.quit();
        }
    }

    private void openViewer() {
        this.frame = new ViewerFrame();
        if (this.bounds == null) {
            this.bounds = this.calculateBounds(this.frame.getToolkit().getScreenSize());
        }
        this.frame.pack();
        this.frame.setBounds(this.bounds.getX(), this.bounds.getY(), this.bounds.getWidth(), this.bounds.getHeight());
        this.viewer = (XViewer)Toolkit.getViewer();
        this.viewer.setRenderingArea(this.frame);
        this.viewer.setUpdateNotifier(this.updateNotifier);
        this.viewer.setListener(this.shutdownListener);
        this.viewer.setExploration(this.showExplorationMethods());
        if (this.helpViewer == null) {
            this.helpViewer = new InternalHelpViewer(this.viewer);
        }
        this.viewer.setHelpViewer(this.helpViewer);
        this.frame.setViewer(this.viewer);
        Session currentSession = NakedObjectsContext.getSession();
        if (currentSession == null) {
            throw new NullPointerException("No session for " + (Object)((Object)this));
        }
        RootWorkspaceSpecification spec = new RootWorkspaceSpecification();
        NakedObject perspective = NakedObjectsContext.getPerspective();
        RootObject content = new RootObject(perspective);
        if (!spec.canDisplay(content)) {
            throw new NakedObjectRuntimeException();
        }
        View view = spec.createView(content, null);
        this.viewer.setRootView(view);
        this.viewer.init();
        String name = ((Perspective)perspective.getObject()).getName();
        this.frame.setTitle(this.title == null ? name : this.title);
        this.frame.init();
        this.viewer.initSize();
        this.viewer.scheduleRepaint();
        this.frame.show();
        this.frame.toFront();
    }

    public void set_HelpViewer(HelpViewer helpViewer) {
        this.setHelpViewer(helpViewer);
    }

    public void set_ShutdownListener(ShutdownListener listener) {
        this.setShutdownListener(listener);
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public void setHelpViewer(HelpViewer helpViewer) {
        this.helpViewer = helpViewer;
    }

    public void setShutdownListener(ShutdownListener shutdownListener) {
        this.shutdownListener = shutdownListener;
    }

    private void setupViewFactory() throws ConfigurationException, InstanceCreationException {
        SkylarkViewFactory viewFactory = (SkylarkViewFactory)Toolkit.getViewFactory();
        LOG.debug((Object)"setting up default views (provided by the framework)");
        viewFactory.addValueFieldSpecification(this.loadSpecification("field.image", ImageField.Specification.class));
        viewFactory.addValueFieldSpecification(this.loadSpecification("field.color", ColorField.Specification.class));
        viewFactory.addValueFieldSpecification(this.loadSpecification("field.password", PasswordFieldSpecification.class));
        viewFactory.addValueFieldSpecification(this.loadSpecification("field.wrappedtext", WrappedTextFieldSpecification.class));
        viewFactory.addValueFieldSpecification(this.loadSpecification("field.checkbox", CheckboxField.Specification.class));
        viewFactory.addValueFieldSpecification(this.loadSpecification("field.text", TextFieldSpecification.class));
        viewFactory.addRootWorkspaceSpecification(new RootWorkspaceSpecification());
        viewFactory.addWorkspaceSpecification(new InnerWorkspaceSpecification());
        if (NakedObjectsContext.getConfiguration().getBoolean("nakedobjects.viewer.dnd.specification.defaults", true)) {
            viewFactory.addCompositeRootViewSpecification(new ListSpecification());
            viewFactory.addCompositeRootViewSpecification(new TreeBrowserSpecification());
            viewFactory.addCompositeRootViewSpecification(new WindowFormSpecification());
            viewFactory.addCompositeRootViewSpecification(new WindowTableSpecification());
        }
        viewFactory.addCompositeRootViewSpecification(new MessageDialogSpecification());
        viewFactory.addCompositeRootViewSpecification(new DetailedMessageViewSpecification());
        viewFactory.addEmptyFieldSpecification(this.loadSpecification("field.empty", EmptyField.Specification.class));
        viewFactory.addSubviewIconSpecification(this.loadSpecification("icon.subview", SubviewIconSpecification.class));
        viewFactory.addObjectIconSpecification(this.loadSpecification("icon.object", RootIconSpecification.class));
        viewFactory.addSubviewApplicationClassIconSpecification(this.loadSpecification("icon.service", SubviewIconSpecification.class));
        viewFactory.addServiceIconSpecification(this.loadSpecification("icon.service", ServiceIconSpecification.class));
        viewFactory.setDragContentSpecification(this.loadSpecification("drag-content", DragContentSpecification.class));
        String viewParams = NakedObjectsContext.getConfiguration().getString("nakedobjects.viewer.dnd.specification.view");
        if (viewParams != null) {
            StringTokenizer st = new StringTokenizer(viewParams, ",");
            while (st.hasMoreTokens()) {
                String specName = st.nextToken().trim();
                if (specName == null || specName.trim().equals("")) continue;
                ViewSpecification spec = (ViewSpecification)InstanceFactory.createInstance((String)specName);
                LOG.info((Object)("adding view specification: " + spec));
                viewFactory.addCompositeRootViewSpecification(spec);
            }
        }
    }
}

