/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.viewer;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.noa.spec.Features;
import org.nakedobjects.noa.spec.NakedObjectSpecification;
import org.nakedobjects.nof.core.util.DebugString;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.OneToManyField;
import org.nakedobjects.nos.client.dnd.ValueContent;
import org.nakedobjects.nos.client.dnd.ValueField;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAxis;
import org.nakedobjects.nos.client.dnd.ViewFactory;
import org.nakedobjects.nos.client.dnd.ViewSpecification;
import org.nakedobjects.nos.client.dnd.basic.FallbackView;
import org.nakedobjects.nos.client.dnd.basic.MinimizedView;
import org.nakedobjects.nos.client.dnd.border.DisposedObjectBorder;
import org.nakedobjects.nos.client.dnd.view.dialog.ActionDialogSpecification;
import org.nakedobjects.nos.client.dnd.view.form.InternalListSpecification;
import org.nakedobjects.nos.client.dnd.view.simple.DragViewOutline;

public class SkylarkViewFactory
implements ViewFactory {
    private static final ViewSpecification fallback = new FallbackView.Specification();
    private static final ViewSpecification dialogSpec = new ActionDialogSpecification();
    public static final int INTERNAL = 2;
    private static final Logger LOG = Logger.getLogger(SkylarkViewFactory.class);
    public static final int WINDOW = 1;
    private ViewSpecification emptyFieldSpecification;
    private final Vector rootViews = new Vector();
    private ViewSpecification smallObjectIconSpecification;
    private ViewSpecification smallApplicationClassIconSpecification;
    private final Vector subviews = new Vector();
    private final Vector valueFields = new Vector();
    private ViewSpecification workspaceClassIconSpecification;
    private ViewSpecification workspaceServiceIconSpecification;
    private ViewSpecification workspaceObjectIconSpecification;
    private ViewSpecification rootWorkspaceSpecification;
    private ViewSpecification workspaceSpecification;
    private ViewSpecification dragContentSpecification;

    public void addClassIconSpecification(ViewSpecification spec) {
        this.workspaceClassIconSpecification = spec;
    }

    public void addServiceIconSpecification(ViewSpecification spec) {
        this.workspaceServiceIconSpecification = spec;
    }

    public void addCompositeRootViewSpecification(ViewSpecification spec) {
        this.rootViews.addElement(spec);
    }

    public void addCompositeSubviewViewSpecification(ViewSpecification spec) {
        this.subviews.addElement(spec);
    }

    public void addEmptyFieldSpecification(ViewSpecification spec) {
        this.emptyFieldSpecification = spec;
    }

    public void addObjectIconSpecification(ViewSpecification spec) {
        this.workspaceObjectIconSpecification = spec;
    }

    public void addSubviewIconSpecification(ViewSpecification spec) {
        this.smallObjectIconSpecification = spec;
    }

    public void addSubviewApplicationClassIconSpecification(ViewSpecification spec) {
        this.smallApplicationClassIconSpecification = spec;
    }

    public void addValueFieldSpecification(ViewSpecification spec) {
        this.valueFields.addElement(spec);
    }

    public void addRootWorkspaceSpecification(ViewSpecification spec) {
        this.rootWorkspaceSpecification = spec;
    }

    public void addWorkspaceSpecification(ViewSpecification spec) {
        this.workspaceSpecification = spec;
    }

    public Enumeration closedSubviews(Content forContent, View replacingView) {
        Vector<ViewSpecification> v = new Vector<ViewSpecification>();
        if (forContent instanceof ObjectContent) {
            v.addElement(this.smallObjectIconSpecification);
        }
        return v.elements();
    }

    public View createIcon(Content content) {
        ViewSpecification spec = this.getIconizedRootViewSpecification(content);
        View view = this.createView(spec, content, null);
        LOG.debug((Object)("creating " + view + " (icon) for " + content));
        return view;
    }

    public View createWindow(Content content) {
        ViewSpecification spec = this.getOpenRootViewSpecification(content);
        View view = this.createView(spec, content, null);
        LOG.debug((Object)("creating " + view + " (window) for " + content));
        return view;
    }

    public View createDialog(Content content) {
        return dialogSpec.createView(content, null);
    }

    public View createFieldView(ObjectContent content, ViewAxis axis) {
        ViewSpecification objectFieldSpecification = this.getIconizedSubViewSpecification(content);
        return this.createView(objectFieldSpecification, content, axis);
    }

    public View createFieldView(ValueField content, ViewAxis axis) {
        ViewSpecification valueFieldSpecification = this.getValueFieldSpecification(content);
        return this.createView(valueFieldSpecification, content, axis);
    }

    public View createInternalList(OneToManyField content, ViewAxis axis) {
        InternalListSpecification listSpecification = new InternalListSpecification();
        return this.createView(listSpecification, content, axis);
    }

    private View createView(ViewSpecification specification, Content content, ViewAxis axis) {
        NakedObject adapter;
        ViewSpecification spec;
        if (specification == null) {
            LOG.warn((Object)("no suitable view for " + content + " using fallback view"));
            spec = new FallbackView.Specification();
        } else {
            spec = specification;
        }
        View createView = spec.createView(content, axis);
        if (content.isObject() && (adapter = (NakedObject)content.getNaked()) != null && adapter.getResolveState().isDestroyed()) {
            createView = new DisposedObjectBorder(createView);
        }
        return createView;
    }

    public View createInnerWorkspace(Content content) {
        LOG.debug((Object)("creating inner workspace for " + content));
        View view = this.createView(this.workspaceSpecification, content, null);
        return view;
    }

    private ViewSpecification defaultViewSpecification(Vector availableViews, Content content) {
        Enumeration fields = availableViews.elements();
        while (fields.hasMoreElements()) {
            ViewSpecification spec = (ViewSpecification)fields.nextElement();
            if (!spec.canDisplay(content)) continue;
            return spec;
        }
        LOG.warn((Object)("no suitable view for " + content + " using fallback view"));
        return new FallbackView.Specification();
    }

    private ViewSpecification ensureView(ViewSpecification spec) {
        if (spec == null) {
            LOG.error((Object)"missing view; using fallback");
            return new FallbackView.Specification();
        }
        return spec;
    }

    public void debugData(DebugString sb) {
        ViewSpecification spec;
        sb.append((Object)"RootsViews\n");
        Enumeration fields = this.rootViews.elements();
        while (fields.hasMoreElements()) {
            spec = (ViewSpecification)fields.nextElement();
            sb.append((Object)"  ");
            sb.append((Object)spec);
            sb.append((Object)"\n");
        }
        sb.append((Object)"\n\n");
        sb.append((Object)"Subviews\n");
        fields = this.subviews.elements();
        while (fields.hasMoreElements()) {
            spec = (ViewSpecification)fields.nextElement();
            sb.append((Object)"  ");
            sb.append((Object)spec);
            sb.append((Object)"\n");
        }
        sb.append((Object)"\n\n");
        sb.append((Object)"Value fields\n");
        fields = this.valueFields.elements();
        while (fields.hasMoreElements()) {
            spec = (ViewSpecification)fields.nextElement();
            sb.append((Object)"  ");
            sb.append((Object)spec);
            sb.append((Object)"\n");
        }
        sb.append((Object)"\n\n");
    }

    public String debugTitle() {
        return "View factory entries";
    }

    public ViewSpecification getContentDragSpecification() {
        return this.dragContentSpecification;
    }

    public ViewSpecification getEmptyFieldSpecification() {
        if (this.emptyFieldSpecification == null) {
            LOG.error((Object)"missing empty field specification; using fallback");
            return fallback;
        }
        return this.emptyFieldSpecification;
    }

    public ViewSpecification getIconizedRootViewSpecification(Content content) {
        if (Features.isService((NakedObjectSpecification)content.getNaked().getSpecification())) {
            if (this.workspaceServiceIconSpecification == null) {
                LOG.error((Object)"missing workspace class icon specification; using fallback");
                return fallback;
            }
            return this.ensureView(this.workspaceServiceIconSpecification);
        }
        if (this.workspaceObjectIconSpecification == null) {
            LOG.error((Object)"missing workspace object icon specification; using fallback");
            return fallback;
        }
        return this.ensureView(this.workspaceObjectIconSpecification);
    }

    public ViewSpecification getIconizedSubViewSpecification(Content content) {
        if (content.getNaked() == null) {
            return this.getEmptyFieldSpecification();
        }
        if (Features.isService((NakedObjectSpecification)content.getNaked().getSpecification())) {
            if (this.smallApplicationClassIconSpecification == null) {
                LOG.error((Object)"missing small class icon specification; using fall back");
                return fallback;
            }
            return this.ensureView(this.smallApplicationClassIconSpecification);
        }
        if (this.smallObjectIconSpecification == null) {
            LOG.error((Object)"missing small object icon specification; using fall back");
            return fallback;
        }
        return this.ensureView(this.smallObjectIconSpecification);
    }

    private ViewSpecification getOpenRootViewSpecification(Content content) {
        return this.defaultViewSpecification(this.rootViews, content);
    }

    public ViewSpecification getOpenSubViewSpecification(ObjectContent content) {
        return this.defaultViewSpecification(this.subviews, content);
    }

    public ViewSpecification getOverlayViewSpecification(Content content) {
        return fallback;
    }

    public ViewSpecification getValueFieldSpecification(ValueContent content) {
        if (content.isOptionEnabled()) {
            // empty if block
        }
        return this.defaultViewSpecification(this.valueFields, content);
    }

    public Enumeration openRootViews(Content forContent, View replacingView) {
        return this.viewSpecifications(this.rootViews, forContent);
    }

    public Enumeration openSubviews(Content forContent, View replacingView) {
        if (forContent instanceof ObjectContent) {
            return this.viewSpecifications(this.subviews, forContent);
        }
        return new Vector().elements();
    }

    public Enumeration valueViews(Content forContent, View replacingView) {
        return new Vector().elements();
    }

    public void setDragContentSpecification(ViewSpecification dragContentSpecification) {
        this.dragContentSpecification = dragContentSpecification;
    }

    private Enumeration viewSpecifications(Vector availableViews, Content content) {
        Vector<ViewSpecification> v = new Vector<ViewSpecification>();
        Enumeration fields = availableViews.elements();
        while (fields.hasMoreElements()) {
            ViewSpecification spec = (ViewSpecification)fields.nextElement();
            if (!spec.canDisplay(content)) continue;
            v.addElement(spec);
        }
        return v.elements();
    }

    public View createDragViewOutline(View view) {
        return new DragViewOutline(view);
    }

    public View createMinimizedView(View view) {
        return new MinimizedView(view);
    }
}

