/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.viewer;

import java.awt.Cursor;
import java.util.Vector;
import org.nakedobjects.noa.adapter.NakedObject;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nos.client.dnd.BackgroundTask;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Feedback;
import org.nakedobjects.nos.client.dnd.ObjectContent;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.view.message.ExceptionMessageContent;
import org.nakedobjects.nos.client.dnd.view.message.TextMessageContent;
import org.nakedobjects.nos.client.dnd.viewer.XViewer;

public class XFeedbackManager
implements Feedback {
    private final XViewer viewer;
    private final Vector busy = new Vector();
    private String messages;
    private String view;
    private String action;
    private String error;
    private String message;
    private Cursor cursor;

    public XFeedbackManager(XViewer viewer) {
        this.viewer = viewer;
    }

    public String getStatusBarOutput() {
        StringBuffer text = new StringBuffer();
        this.append(text, this.view);
        this.append(text, this.action);
        this.append(text, this.error);
        this.append(text, this.message);
        this.append(text, this.messages);
        return text.toString();
    }

    private void append(StringBuffer text, String entry) {
        if (entry != null && !entry.equals("")) {
            if (text.length() > 0) {
                text.append(";  ");
            }
            text.append(entry);
        }
    }

    public void clearStatus() {
    }

    public void setBusy(View view, BackgroundTask task) {
        if (view.getContent().isObject()) {
            NakedObject object = ((ObjectContent)view.getContent()).getObject();
            this.busy.addElement(object);
        }
        this.showBusyState(view);
        this.message = "BUSY";
    }

    public void clearBusy(View view) {
        if (view.getContent().isObject()) {
            NakedObject object = ((ObjectContent)view.getContent()).getObject();
            this.busy.removeElement(object);
        }
        this.showBusyState(view);
        if (this.busy.size() == 0) {
            this.message = "";
            this.viewer.forcePaintOfStatusBar();
        }
    }

    public boolean isBusy(View view) {
        if (view != null) {
            NakedObject object;
            Content content = view.getContent();
            if (content != null && content.isObject() && this.busy.contains(object = ((ObjectContent)content).getObject())) {
                return true;
            }
            View parent = view.getParent();
            return parent != null && this.isBusy(parent);
        }
        return false;
    }

    public void showBusyState(View view) {
        Cursor cursor = this.isBusy(view) ? Cursor.getPredefinedCursor(3) : this.cursor;
        this.viewer.setCursor(cursor);
    }

    public void setViewDetail(String text) {
        this.view = text;
        this.viewer.forcePaintOfStatusBar();
    }

    public void addMessage(String text) {
        this.message = text;
        this.viewer.forcePaintOfStatusBar();
    }

    public void clearAction() {
        this.action = null;
        this.viewer.forcePaintOfStatusBar();
    }

    public void setAction(String text) {
        this.action = text;
        this.viewer.forcePaintOfStatusBar();
    }

    public void setError(String text) {
        this.error = text;
        this.viewer.forcePaintOfStatusBar();
    }

    public void showMessagesAndWarnings() {
        String[] messages = NakedObjectsContext.getMessageBroker().getMessages();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < messages.length; ++i) {
            if (i > 0) {
                buf.append("; ");
            }
            buf.append(messages[i]);
        }
        this.messages = buf.toString();
        String[] warnings = NakedObjectsContext.getMessageBroker().getWarnings();
        for (int i = 0; i < warnings.length; ++i) {
            TextMessageContent content = new TextMessageContent("Warning", warnings[i]);
            this.viewer.showDialog(content);
        }
    }

    public void showException(Throwable e) {
        ExceptionMessageContent content = new ExceptionMessageContent(e);
        this.viewer.showDialog(content);
    }

    public void showArrowCursor() {
        this.setCursor(0);
    }

    public void showCrosshairCursor() {
        this.setCursor(1);
    }

    public void showDefaultCursor() {
        this.setCursor(0);
    }

    public void showHandCursor() {
        this.setCursor(12);
    }

    public void showMoveCursor() {
        this.setCursor(13);
    }

    public void showResizeDownCursor() {
        this.setCursor(9);
    }

    public void showResizeDownLeftCursor() {
        this.setCursor(4);
    }

    public void showResizeDownRightCursor() {
        this.setCursor(5);
    }

    public void showResizeLeftCursor() {
        this.setCursor(10);
    }

    public void showResizeRightCursor() {
        this.setCursor(11);
    }

    public void showResizeUpCursor() {
        this.setCursor(8);
    }

    public void showResizeUpLeftCursor() {
        this.setCursor(6);
    }

    public void showResizeUpRightCursor() {
        this.setCursor(7);
    }

    public void showTextCursor() {
        this.setCursor(2);
    }

    private void setCursor(int cursorStyle) {
        this.cursor = Cursor.getPredefinedCursor(cursorStyle);
        this.viewer.setCursor(this.cursor);
    }
}

