/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.nos.client.dnd.viewer;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import org.apache.log4j.Logger;
import org.nakedobjects.noa.NakedObjectRuntimeException;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.undo.UndoStack;
import org.nakedobjects.nof.core.util.DebugFrame;
import org.nakedobjects.nof.core.util.ToString;
import org.nakedobjects.nos.client.dnd.Background;
import org.nakedobjects.nos.client.dnd.Canvas;
import org.nakedobjects.nos.client.dnd.Click;
import org.nakedobjects.nos.client.dnd.Content;
import org.nakedobjects.nos.client.dnd.Drag;
import org.nakedobjects.nos.client.dnd.DragStart;
import org.nakedobjects.nos.client.dnd.FocusManager;
import org.nakedobjects.nos.client.dnd.HelpViewer;
import org.nakedobjects.nos.client.dnd.InteractionSpy;
import org.nakedobjects.nos.client.dnd.Toolkit;
import org.nakedobjects.nos.client.dnd.UserActionSet;
import org.nakedobjects.nos.client.dnd.View;
import org.nakedobjects.nos.client.dnd.ViewAreaType;
import org.nakedobjects.nos.client.dnd.Viewer;
import org.nakedobjects.nos.client.dnd.basic.PopupMenu;
import org.nakedobjects.nos.client.dnd.drawing.Bounds;
import org.nakedobjects.nos.client.dnd.drawing.Location;
import org.nakedobjects.nos.client.dnd.drawing.Size;
import org.nakedobjects.nos.client.dnd.notifier.ViewUpdateNotifier;
import org.nakedobjects.nos.client.dnd.view.message.MessageContent;
import org.nakedobjects.nos.client.dnd.view.simple.NullView;
import org.nakedobjects.nos.client.dnd.viewer.ApplicationOptions;
import org.nakedobjects.nos.client.dnd.viewer.AwtCanvas;
import org.nakedobjects.nos.client.dnd.viewer.AwtColor;
import org.nakedobjects.nos.client.dnd.viewer.AwtText;
import org.nakedobjects.nos.client.dnd.viewer.DebugOptions;
import org.nakedobjects.nos.client.dnd.viewer.InteractionHandler;
import org.nakedobjects.nos.client.dnd.viewer.KeyboardManager;
import org.nakedobjects.nos.client.dnd.viewer.LoggingOptions;
import org.nakedobjects.nos.client.dnd.viewer.RenderingArea;
import org.nakedobjects.nos.client.dnd.viewer.ShutdownListener;
import org.nakedobjects.nos.client.dnd.viewer.SpyWindow;
import org.nakedobjects.nos.client.dnd.viewer.XFeedbackManager;

public class XViewer
implements Viewer {
    private static final Size NO_SIZE = new Size(0, 0);
    private static final Logger LOG = Logger.getLogger(Viewer.class);
    private static final Logger UI_LOG = Logger.getLogger((String)("ui." + Viewer.class.getName()));
    private static final LoggingOptions LOGGING_OPTIONS = new LoggingOptions();
    private static final NullView CLEAR_OVERLAY = new NullView();
    private static final Bounds NO_REDRAW = new Bounds();
    private ApplicationOptions APPLICATION_OPTIONS;
    private final DebugOptions DEBUG_OPTIONS = new DebugOptions(this);
    private Graphics bufferGraphics;
    private Image doubleBuffer;
    private boolean doubleBuffering = false;
    private Insets insets;
    private Size internalDisplaySize = new Size(1, 1);
    private ShutdownListener listener;
    private View overlayView;
    private final Bounds redrawArea;
    private int redrawCount = 100000;
    private RenderingArea renderingArea;
    private View rootView;
    private String status;
    private boolean runningAsExploration;
    boolean showExplorationMenuByDefault;
    boolean showRepaintArea;
    private InteractionSpy spy;
    private int statusBarHeight;
    private final UndoStack undoStack = new UndoStack();
    protected ViewUpdateNotifier updateNotifier;
    private KeyboardManager keyboardManager;
    private HelpViewer helpViewer;
    private Background background;
    private Bounds statusBarArea;
    private XFeedbackManager feedbackManager;
    private boolean refreshStatus;
    private static Boolean isDotNetBool;

    private static boolean isDotNet() {
        if (isDotNetBool == null) {
            isDotNetBool = new Boolean(System.getProperty("java.version", "dotnet").equals("dotnet"));
        }
        return isDotNetBool;
    }

    public XViewer() {
        this.doubleBuffering = NakedObjectsContext.getConfiguration().getBoolean("nakedobjects.viewer.dnd.double-buffer", true);
        this.showExplorationMenuByDefault = NakedObjectsContext.getConfiguration().getBoolean("nakedobjects.viewer.dnd.exploration.show", true);
        this.overlayView = CLEAR_OVERLAY;
        this.redrawArea = new Bounds();
    }

    public void addSpyAction(String actionMessage) {
        if (this.spy != null) {
            this.spy.addAction(actionMessage);
        }
    }

    public void addToNotificationList(View view) {
        this.updateNotifier.add(view.getView());
    }

    public String selectFilePath(String title, String directory) {
        return this.renderingArea.selectFilePath(title, directory);
    }

    public void setKeyboardFocus(View view) {
        FocusManager focusManager;
        View currentFocus;
        if (view == null) {
            return;
        }
        FocusManager currentFocusManager = this.keyboardManager.getFocusManager();
        if (currentFocusManager != null && currentFocusManager.getFocus() != null && currentFocusManager.getFocus().getParent() != null) {
            currentFocusManager.getFocus().getParent().markDamaged();
        }
        if (currentFocusManager != null && (currentFocus = currentFocusManager.getFocus()) != null && currentFocus != view) {
            currentFocus.focusLost();
        }
        if ((focusManager = view.getFocusManager()) != null) {
            focusManager.setFocus(view);
            if (view.getParent() != null) {
                view.getParent().markDamaged();
            }
        }
        if (focusManager == null) {
            LOG.warn((Object)("No focus manager for " + view));
        } else {
            this.keyboardManager.setFocusManager(focusManager);
        }
    }

    public void clearOverlayView() {
        this.overlayView.markDamaged();
        this.overlayView = CLEAR_OVERLAY;
    }

    public void clearOverlayView(View view) {
        if (this.getOverlayView() != view) {
            LOG.warn((Object)("no such view to remove: " + view));
        }
        this.clearOverlayView();
    }

    public void quit() {
        if (this.spy != null) {
            this.spy.close();
        }
        DebugFrame.disposeAll();
        this.close();
        if (this.listener != null) {
            this.listener.quit();
        }
    }

    public void disposeOverlayView() {
        this.clearOverlayView();
    }

    public void disposeUnneededViews() {
        this.updateNotifier.removeViewsForDisposedObjects();
    }

    public View dragFrom(Location location) {
        if (this.onOverlay(location)) {
            location.subtract(this.overlayView.getLocation());
            return this.overlayView.dragFrom(location);
        }
        return this.rootView.dragFrom(location);
    }

    public Drag dragStart(DragStart start) {
        if (this.onOverlay(start.getLocation())) {
            start.subtract(this.overlayView.getLocation());
            return this.overlayView.dragStart(start);
        }
        return this.rootView.dragStart(start);
    }

    public void firstClick(Click click) {
        if (this.onOverlay(click.getLocation())) {
            click.subtract(this.overlayView.getLocation());
            this.overlayView.firstClick(click);
        } else {
            this.rootView.firstClick(click);
        }
    }

    private FocusManager getFocusManager() {
        return this.overlayView == CLEAR_OVERLAY ? this.keyboardManager.getFocusManager() : this.overlayView.getFocusManager();
    }

    public Bounds getOverlayBounds() {
        Bounds bounds = new Bounds(this.createSize(this.renderingArea.getSize()));
        Insets in = this.renderingArea.getInsets();
        bounds.contract(in.left + in.right, in.top + in.bottom);
        bounds.contract(0, this.statusBarHeight);
        return bounds;
    }

    private Size createSize(Dimension size) {
        return new Size(size.width, size.height);
    }

    public View getOverlayView() {
        return this.overlayView;
    }

    public InteractionSpy getSpy() {
        return this.spy;
    }

    public UndoStack getUndoStack() {
        return this.undoStack;
    }

    public boolean hasFocus(View view) {
        FocusManager focusManager = this.keyboardManager.getFocusManager();
        return focusManager != null && focusManager.getFocus() == view;
    }

    public View identifyView(Location location, boolean includeOverlay) {
        if (includeOverlay && this.onOverlay(location)) {
            location.subtract(this.overlayView.getLocation());
            return this.overlayView.identify(location);
        }
        return this.rootView.identify(location);
    }

    public void init() {
        if (this.updateNotifier == null) {
            throw new NullPointerException("No update notifier set for " + this);
        }
        if (this.rootView == null) {
            throw new NullPointerException("No root view set for " + this);
        }
        this.insets = new Insets(0, 0, 0, 0);
        this.spy = new InteractionSpy(new SpyWindow());
        this.keyboardManager = new KeyboardManager(this);
        InteractionHandler interactionHandler = new InteractionHandler(this, this.feedbackManager, this.keyboardManager, this.spy);
        this.renderingArea.addMouseMotionListener(interactionHandler);
        this.renderingArea.addMouseListener(interactionHandler);
        this.renderingArea.addKeyListener(interactionHandler);
        if (NakedObjectsContext.getConfiguration().getBoolean("nakedobjects.viewer.dnd.show-mouse-spy", false)) {
            this.spy.open();
        }
        this.setKeyboardFocus(this.rootView);
        this.APPLICATION_OPTIONS = new ApplicationOptions(this.listener);
    }

    public boolean isRunningAsExploration() {
        return this.runningAsExploration;
    }

    public boolean isShowingMouseSpy() {
        return this.spy.isVisible();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markDamaged(Bounds bounds) {
        if (this.spy != null) {
            this.spy.addDamagedArea(bounds);
        }
        Bounds bounds2 = this.redrawArea;
        synchronized (bounds2) {
            if (this.redrawArea.equals(NO_REDRAW)) {
                this.redrawArea.setBounds(bounds);
                UI_LOG.debug((Object)("damage - new area " + this.redrawArea));
            } else if (!bounds.getSize().equals(NO_SIZE)) {
                this.redrawArea.union(bounds);
                UI_LOG.debug((Object)("damage - extend area " + this.redrawArea + " - to include " + bounds));
            }
        }
    }

    public void menuOptions(UserActionSet options) {
    }

    public void mouseDown(Click click) {
        if (this.onOverlay(click.getLocation())) {
            click.subtract(this.overlayView.getLocation());
            this.overlayView.mouseDown(click);
        } else {
            this.rootView.mouseDown(click);
        }
    }

    public void mouseMoved(Location location) {
        if (this.onOverlay(location)) {
            location.subtract(this.overlayView.getLocation());
            this.overlayView.mouseMoved(location);
        } else {
            this.rootView.mouseMoved(location);
        }
    }

    public void mouseUp(Click click) {
        if (this.onOverlay(click.getLocation())) {
            click.subtract(this.overlayView.getLocation());
            this.overlayView.mouseUp(click);
        } else {
            this.rootView.mouseUp(click);
        }
    }

    private boolean onOverlay(Location mouse) {
        return this.overlayView.getBounds().contains(mouse);
    }

    public void paint(Graphics graphic) {
        ++this.redrawCount;
        graphic.translate(this.insets.left, this.insets.top);
        Rectangle paintArea = graphic.getClipBounds();
        Rectangle layoutArea = this.layoutViews();
        if (layoutArea != null) {
            paintArea.union(layoutArea);
        }
        if (this.spy != null) {
            this.spy.redraw(paintArea.toString(), this.redrawCount);
        }
        if (UI_LOG.isDebugEnabled()) {
            UI_LOG.debug((Object)("------ repaint viewer #" + this.redrawCount + " " + paintArea.x + "," + paintArea.y + " " + paintArea.width + "x" + paintArea.height));
        }
        Canvas c = this.createCanvas(graphic, paintArea);
        if (this.background != null) {
            this.background.draw(c.createSubcanvas(), this.rootView.getSize());
        }
        if (this.rootView != null) {
            this.rootView.draw(c.createSubcanvas());
        }
        this.overlayView.draw(c.createSubcanvas(this.overlayView.getBounds()));
        if (this.doubleBuffering) {
            graphic.drawImage(this.doubleBuffer, 0, 0, null);
        }
        if (this.showRepaintArea) {
            graphic.setColor(((AwtColor)Toolkit.getColor("debug.bounds.repaint")).getAwtColor());
            graphic.drawRect(paintArea.x, paintArea.y, paintArea.width - 1, paintArea.height - 1);
            graphic.drawString("#" + this.redrawCount, paintArea.x + 3, paintArea.y + 15);
        }
        this.paintStatus(graphic);
    }

    private Canvas createCanvas(Graphics graphic, Rectangle paintArea) {
        int w = this.internalDisplaySize.getWidth();
        int h = this.internalDisplaySize.getHeight();
        if (this.doubleBuffering) {
            if (this.doubleBuffer == null || this.bufferGraphics == null || this.doubleBuffer.getWidth(null) < w || this.doubleBuffer.getHeight(null) < h) {
                this.doubleBuffer = this.renderingArea.createImage(w, h);
                LOG.debug((Object)("buffer sized to " + this.doubleBuffer.getWidth(null) + "x" + this.doubleBuffer.getHeight(null)));
            }
            this.bufferGraphics = this.doubleBuffer.getGraphics().create();
        } else {
            this.bufferGraphics = graphic;
        }
        this.bufferGraphics.clearRect(paintArea.x, paintArea.y, paintArea.width, paintArea.height);
        this.bufferGraphics.clearRect(0, 0, w, h);
        this.bufferGraphics.setClip(paintArea.x, paintArea.y, paintArea.width, paintArea.height);
        AwtCanvas c = new AwtCanvas(this.bufferGraphics, paintArea.x, paintArea.y, paintArea.width, paintArea.height);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Rectangle layoutViews() {
        if (!Thread.currentThread().getName().startsWith("AWT-EventQueue") && !XViewer.isDotNet()) {
            throw new NakedObjectRuntimeException("Drawing with wrong thread: " + Thread.currentThread());
        }
        Size rootViewSize = this.rootView.getSize();
        this.overlayView.layout(rootViewSize);
        this.rootView.layout(rootViewSize);
        Bounds bounds = this.redrawArea;
        synchronized (bounds) {
            if (!this.redrawArea.equals(NO_REDRAW)) {
                Rectangle r2 = new Rectangle(this.redrawArea.getX(), this.redrawArea.getY(), this.redrawArea.getWidth(), this.redrawArea.getHeight());
                this.redrawArea.setBounds(NO_REDRAW);
                return r2;
            }
        }
        return null;
    }

    private void paintStatus(Graphics graphic) {
        int height = this.internalDisplaySize.getHeight();
        int top = height - this.statusBarHeight;
        if (this.refreshStatus || graphic.getClip().getBounds().getY() + graphic.getClip().getBounds().getHeight() > (double)top) {
            this.refreshStatus = false;
            UI_LOG.debug((Object)("changed user status " + this.status + " " + this.statusBarArea));
            int width = this.internalDisplaySize.getWidth();
            graphic.setClip(0, top, width, this.statusBarHeight);
            graphic.setColor(((AwtColor)Toolkit.getColor("secondary3")).getAwtColor());
            AwtText textStyle = (AwtText)Toolkit.getText("status");
            graphic.setFont(textStyle.getAwtFont());
            int baseline = top + textStyle.getAscent();
            graphic.fillRect(0, top, width, this.statusBarHeight);
            graphic.setColor(((AwtColor)Toolkit.getColor("secondary1")).getAwtColor());
            graphic.drawRect(0, top, width - 1, this.statusBarHeight - 1);
            graphic.setColor(((AwtColor)Toolkit.getColor("black")).getAwtColor());
            graphic.drawString(this.status, 5, baseline + View.VPADDING);
        }
    }

    public View pickupContent(Location location) {
        if (this.onOverlay(location)) {
            location.subtract(this.overlayView.getLocation());
            return this.overlayView.pickupContent(location);
        }
        return this.rootView.pickupContent(location);
    }

    public View pickupView(Location location) {
        if (this.onOverlay(location)) {
            location.subtract(this.overlayView.getLocation());
            return this.overlayView.pickupView(location);
        }
        return this.rootView.pickupView(location);
    }

    public void popupMenu(View over, Location at, boolean forView, boolean includeExploration, boolean includeDebug) {
        this.feedbackManager.setBusy(over, null);
        this.saveCurrentFieldEntry();
        PopupMenu menu = new PopupMenu();
        menu.setLocation(at);
        if (over == this.rootView) {
            menu.addMenuOptions(this.APPLICATION_OPTIONS);
            menu.addMenuOptions(LOGGING_OPTIONS);
            menu.addMenuOptions(this.DEBUG_OPTIONS);
        }
        boolean showExplorationOptions = includeExploration || this.showExplorationMenuByDefault;
        menu.show(over, forView, includeDebug, showExplorationOptions);
        this.feedbackManager.clearBusy(over);
    }

    public void removeFromNotificationList(View view) {
        this.updateNotifier.remove(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleRepaint() {
        this.updateNotifier.invalidateViewsForChangedObjects();
        Bounds bounds = this.redrawArea;
        synchronized (bounds) {
            if (!this.redrawArea.equals(NO_REDRAW) || this.refreshStatus) {
                UI_LOG.debug((Object)("repaint viewer " + this.redrawArea));
                Bounds area = new Bounds(this.redrawArea);
                area.translate(this.insets.left, this.insets.top);
                this.renderingArea.repaint(area.getX(), area.getY(), area.getWidth(), area.getHeight());
                this.redrawArea.setBounds(NO_REDRAW);
            }
        }
    }

    public void saveCurrentFieldEntry() {
        View focus;
        FocusManager focusManager = this.getFocusManager();
        if (focusManager != null && (focus = focusManager.getFocus()) != null) {
            focus.editComplete();
        }
    }

    public void secondClick(Click click) {
        if (this.onOverlay(click.getLocation())) {
            click.subtract(this.overlayView.getLocation());
            this.overlayView.secondClick(click);
        } else {
            this.rootView.secondClick(click);
        }
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    void setCursor(Cursor cursor) {
        this.renderingArea.setCursor(cursor);
    }

    public void setExploration(boolean asExploration) {
        this.runningAsExploration = asExploration;
    }

    public void setListener(ShutdownListener listener) {
        this.listener = listener;
    }

    public void setOverlayView(View view) {
        this.disposeOverlayView();
        this.overlayView = view;
        Size size = view.getRequiredSize(this.rootView.getSize());
        view.setSize(size);
        view.layout(this.rootView.getSize());
        view.limitBoundsWithin(this.rootView.getSize());
        this.overlayView.markDamaged();
    }

    public void setRenderingArea(RenderingArea renderingArea) {
        this.renderingArea = renderingArea;
    }

    public void setRootView(View rootView) {
        this.rootView = rootView;
        rootView.invalidateContent();
    }

    public void setHelpViewer(HelpViewer helpViewer) {
        this.helpViewer = helpViewer;
    }

    public void setShowMouseSpy(boolean showDeveloperStatus) {
        if (this.spy.isVisible()) {
            this.spy.close();
        } else {
            this.spy.open();
        }
    }

    public void setUpdateNotifier(ViewUpdateNotifier updateNotifier) {
        this.updateNotifier = updateNotifier;
    }

    private void locateInCentre(View view) {
        Size rootSize = this.rootView.getSize();
        Location location = new Location(rootSize.getWidth() / 2, rootSize.getHeight() / 2);
        Size dialogSize = view.getRequiredSize(new Size());
        location.subtract(dialogSize.getWidth() / 2, dialogSize.getHeight() / 2);
        view.setLocation(location);
    }

    public void showSpy() {
        this.spy.open();
    }

    public void sizeChange() {
        this.initSize();
        View[] subviews = this.rootView.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            subviews[i].invalidateLayout();
        }
        Bounds bounds = new Bounds(this.internalDisplaySize);
        this.markDamaged(bounds);
        this.scheduleRepaint();
    }

    public void initSize() {
        this.internalDisplaySize = this.createSize(this.renderingArea.getSize());
        this.insets = this.renderingArea.getInsets();
        LOG.debug((Object)("  insets " + this.insets));
        this.internalDisplaySize.contract(this.insets.left + this.insets.right, this.insets.top + this.insets.bottom);
        LOG.debug((Object)("  internal " + this.internalDisplaySize));
        Size rootViewSize = new Size(this.internalDisplaySize);
        this.statusBarHeight = Toolkit.getText("status").getLineHeight() + Toolkit.getText("status").getDescent();
        rootViewSize.contractHeight(this.statusBarHeight);
        this.statusBarArea = new Bounds(this.insets.left, this.insets.top + rootViewSize.getHeight(), rootViewSize.getWidth(), this.statusBarHeight);
        this.rootView.setSize(rootViewSize);
    }

    public void thirdClick(Click click) {
        if (this.onOverlay(click.getLocation())) {
            click.subtract(this.overlayView.getLocation());
            this.overlayView.thirdClick(click);
        } else {
            this.rootView.thirdClick(click);
        }
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("renderingArea", (Object)this.renderingArea);
        str.append("redrawArea", (Object)this.redrawArea);
        str.append("rootView", (Object)this.rootView);
        return str.toString();
    }

    public void translate(MouseEvent me) {
        me.translatePoint(-this.insets.left, -this.insets.top);
    }

    public ViewAreaType viewAreaType(Location location) {
        if (this.onOverlay(location)) {
            location.subtract(this.overlayView.getLocation());
            return this.overlayView.viewAreaType(location);
        }
        return this.rootView.viewAreaType(location);
    }

    public boolean isOverlayAvailable() {
        return this.overlayView != CLEAR_OVERLAY;
    }

    public void makeRootFocus() {
    }

    public void openHelp(View forView) {
        if (forView != null) {
            String description = null;
            String help = null;
            String name = null;
            if (forView != null && forView.getContent() != null) {
                Content content = forView.getContent();
                description = content.getDescription();
                help = content.getHelp();
                name = content.getId();
                name = name == null ? content.title() : name;
            }
            this.helpViewer.open(forView.getAbsoluteLocation(), name, description, help);
        }
    }

    public Object getClipboard(Class cls) {
        if (cls == String.class) {
            Clipboard cb = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable content = cb.getContents(this);
            String value = "illegal value";
            try {
                value = (String)content.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Throwable e) {
                LOG.error((Object)("invalid clipboard operation " + e));
            }
            return value;
        }
        return null;
    }

    public void setClipboard(String clip, Class class1) {
        Clipboard cb = java.awt.Toolkit.getDefaultToolkit().getSystemClipboard();
        cb.setContents(new StringSelection(clip), null);
    }

    public void forcePaintOfStatusBar() {
        this.status = this.feedbackManager.getStatusBarOutput();
        this.refreshStatus = true;
        this.scheduleRepaint();
    }

    public void showDialog(MessageContent content) {
        View view = Toolkit.getViewFactory().createWindow(content);
        this.locateInCentre(view);
        this.rootView.getWorkspace().addView(view);
        this.scheduleRepaint();
    }

    public void clearAction() {
        this.feedbackManager.clearAction();
        this.clearOverlayView();
    }

    public void setFeedbackManager(XFeedbackManager feedbackManager) {
        this.feedbackManager = feedbackManager;
    }

    public void close() {
        this.renderingArea.dispose();
    }
}

