package org.nakedobjects.nos.webapp;

import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

import org.nakedobjects.noa.security.Session;
import org.nakedobjects.nos.client.web.request.Context;
import org.nakedobjects.nos.client.web.servlet.SystemAccess;


public class SessionList implements HttpSessionListener {
    private static final String NOF_SESSION_ATTRIBUTE = "nof-context";
    public void sessionCreated(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        SystemAccess.addSession(session);
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession session = event.getSession();
        SystemAccess.removeSession(session);

        Context context = (Context) session.getAttribute(NOF_SESSION_ATTRIBUTE);
        Session nofSession = context.getSession();
        if (nofSession != null) {
            SystemAccess.logoffUser(nofSession);
        }

    }

}

// Copyright (c) Naked Objects Group Ltd.
