package org.nakedobjects.nos.webapp;

import java.io.File;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.log4j.Logger;
import org.nakedobjects.nof.boot.system.InstallerLookup;
import org.nakedobjects.nof.boot.system.NakedObjectsSystem;
import org.nakedobjects.nof.core.conf.DefaultConfigurationLoader;
import org.nakedobjects.nof.core.context.NakedObjectsContext;
import org.nakedobjects.nof.core.context.ThreadContext;
import org.nakedobjects.nof.core.image.TemplateImage;
import org.nakedobjects.nof.core.image.TemplateImageLoader;
import org.nakedobjects.nof.core.security.AuthenticatorInstaller;
import org.nakedobjects.nof.core.service.ServicesFromConfiguration;
import org.nakedobjects.nof.core.system.ClientConnectionInstaller;
import org.nakedobjects.nof.core.system.FixturesInstaller;
import org.nakedobjects.nof.core.system.InstanceFactory;
import org.nakedobjects.nof.core.system.ObjectPersistorInstaller;
import org.nakedobjects.nof.core.system.ReflectorInstaller;
import org.nakedobjects.nof.core.system.ServerListenerInstaller;
import org.nakedobjects.nof.core.system.ServicesInstaller;
import org.nakedobjects.nof.core.system.TemplateImageLoaderInstaller;
import org.nakedobjects.nof.reflect.java.fixture.FixturesFromConfiguration;
import org.nakedobjects.nof.reflect.java.reflect.JavaReflectorInstaller;
import org.nakedobjects.nos.client.web.component.ImageLookup;
import org.nakedobjects.nos.client.web.servlet.SystemAccess;


/**
 * Initialize the NakedObjectsSystem when the web application starts, and destroy it when it ends
 */
public class ServletInitializer implements ServletContextListener {
    private static final Logger LOG = Logger.getLogger(ServletInitializer.class);

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletInitializer instance = new ServletInitializer();
        instance.init(servletContextEvent.getServletContext());
    }

    private void init(ServletContext servletContext) {
        String dir = servletContext.getRealPath("/WEB-INF");
        NakedObjectsSystem system = new NakedObjectsSystem(dir);
        system.setServer(true);
        LOG.debug("current dir: " + new File(".").getAbsolutePath());
        LOG.debug("real path: " + dir);
        DefaultConfigurationLoader configuration = new DefaultConfigurationLoader(dir);
        configuration.addConfigurationFile("web.properties", false);
        configuration.addConfigurationFile("war.properties", false);
        system.loadConfiguration(configuration);
        system.disableSplash(true);
        InstallerLookup installers = system.getInstallerFactory();
        installers.setConfiguration(configuration.load());

        ReflectorInstaller reflectorInstaller = (ReflectorInstaller) installer(servletContext, "reflector",
                JavaReflectorInstaller.class);
        configuration.addConfigurationFile(reflectorInstaller.getName() + ".properties", false);
        system.setReflectorInstaller(reflectorInstaller);

        ObjectPersistorInstaller persistorInstaller = installers.persistorInstaller(null, true);
        configuration.addConfigurationFile(persistorInstaller.getName() + ".properties", false);
        system.setObjectPersistorInstaller(persistorInstaller);

        ClientConnectionInstaller clientConnectionInstaller = installers.clientConnectionInstaller(null, null);
        if (clientConnectionInstaller != null) {
            configuration.addConfigurationFile(clientConnectionInstaller.getName() + ".properties", false);
            system.setClientConnection(clientConnectionInstaller);
        }

        system.setServicesInstaller((ServicesInstaller) installer(servletContext, "services", ServicesFromConfiguration.class));
        system.setFixtureInstaller((FixturesInstaller) installer(servletContext, "fixtures", FixturesFromConfiguration.class));
        system.setShareObjectsAcrossContexts((flag(servletContext, "share-objects-across-context", false)));

        // TODO need to work out how to set up password authenticator with path to config files
        // system.setAuthenticatorInstaller(new PasswordFileAuthenticatorInstaller(new File(dir,
        // "passwords")));
        AuthenticatorInstaller authenticatorInstaller = installers.authenticatorInstaller(null);
        configuration.addConfigurationFile(authenticatorInstaller.getName() + ".properties", false);
        system.setAuthenticatorInstaller(authenticatorInstaller);

        String listenerInstaller = NakedObjectsContext.getConfiguration().getString(InstallerLookup.PROPERTY_BASE + "listener");
        if (listenerInstaller != null) {
            ServerListenerInstaller installer = installers.listenerInstaller(listenerInstaller);
            system.addListener(installer);
        }

        system.setContext(ThreadContext.createInstance());

        // Load null template image loader.
        system.setTemplateImageLoader(new TemplateImageLoaderInstaller() {
            public org.nakedobjects.nof.core.image.TemplateImageLoader createLoader() {
                return new TemplateImageLoader() {
                    public TemplateImage getTemplateImage(String name) {
                        return null;
                    }
                    public void init() {}
                    public void shutdown() {}
                };
            }
            public String getName() {
                return null;
            };
        });
        
        system.init();

        ImageLookup.setImageDirectory(servletContext.getRealPath("/images"));

        new SystemAccess(system, system.getAuthenticationManager());

        LOG.info("server started");

        servletContext.setAttribute("System", system);
    }

    private boolean flag(final ServletContext servletContext, final String name, final boolean defaultValue) {
        String param = servletContext.getInitParameter(name);
        boolean value = defaultValue;
        boolean defaultUsed = true;
        if (param != null) {
            value = param.equalsIgnoreCase("true");
            defaultUsed = false;
        }
        LOG.info(name + " flag " + value + (defaultUsed ? " (default)" : ""));
        return value;
    }

    private Object installer(final ServletContext servletContext, final String installerName, final Class defaultClass) {
        String installerClass = servletContext.getInitParameter(installerName);
        boolean defaultUsed = false;
        if (installerClass == null && defaultClass != null) {
            installerClass = defaultClass.getName();
            defaultUsed = true;
        }
        if (installerClass == null) {
            LOG.info("No " + installerName + " installer class specified");
            return null;
        }

        Object installer = InstanceFactory.createInstance(installerClass);
        LOG.info(installerName + " installer " + installer + (defaultUsed ? " (default)" : ""));
        return installer;
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        LOG.info("server shutting down");
        final NakedObjectsSystem system = (NakedObjectsSystem) arg0.getServletContext().getAttribute("System");
        if (system != null) {
            LOG.info("calling system shutdown");
            system.shutdown();
        }
        arg0.getServletContext().removeAttribute("System");
    }

    /*
     * private void ejb_init(ServletContext servletContext) { LOG.info("creating naked objects server");
     * NakedObjectsSystem system; system = new NakedObjectsSystem(); system.addAuthenticator(new
     * PasswordFileAuthenticator(new File("passwords"))); system.loadConfiguration(new
     * ResourceConfigurationLoader()); system.setContext(ThreadContext.createInstance()); // TODO: get this in
     * line with NakedObjects String clientConnection =
     * NakedObjectsContext.getConfiguration().getString("nakedobjects.connection"); if (clientConnection !=
     * null) { ClientConnection connection; Class clazz = null; try { // try 1. Get from the application
     * classpath ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader(); clazz =
     * contextClassLoader.loadClass(clientConnection); } catch (Exception e) { throw new
     * NakedObjectRuntimeException(e); } if (clazz == null) { // try 2. if that fails try this classes
     * classloader try { clazz = Class.forName(clientConnection); } catch (ClassNotFoundException e) { throw
     * new NakedObjectRuntimeException(e); } } try { connection = (ClientConnection) clazz.newInstance(); }
     * catch (Exception e) { throw new NakedObjectRuntimeException(e); }
     * system.setObjectPersistorFactory(connection); system.addReflectivePeer(new TransactionPeerFactory()); }
     * 
     * system.disableSplash(true); // system.setPersistorPerContext(true); system.init();
     * 
     * system.showConsole();
     * 
     * ImageLookup.setImageDirectory(servletContext.getRealPath("/images"));
     * 
     * new SystemAccess(system);
     * 
     * LOG.info("server started"); }
     */

}

// Copyright (c) Naked Objects Group Ltd.
