package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.action.CloseWindowControl;
import org.nakedobjects.plugins.dndviewer.viewer.action.WindowControl;


public class DialogBorder extends AbstractWindowBorder {

    public DialogBorder(final View wrappedView, final boolean scrollable) {
        super(scrollable ? new ScrollBorder(wrappedView) : wrappedView);
        setControls(new WindowControl[] { new CloseWindowControl(this) });
    }

    @Override
    protected String title() {
        return getContent().windowTitle();
    }

    @Override
    public String toString() {
        return wrappedView.toString() + "/DialogBorder [" + getSpecification() + "]";
    }
}
// Copyright (c) Naked Objects Group Ltd.
