package org.nakedobjects.plugins.dndviewer.viewer.content;

import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.plugins.dndviewer.OneToManyFieldElement;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;


public class ClearOneToManyAssociationOption extends AbstractUserAction {

    public ClearOneToManyAssociationOption() {
        super("Clear association");
    }

    @Override
    public Consent disabled(final View view) {
        final OneToManyFieldElement content = (OneToManyFieldElement) view.getContent();
        return content.canClear();
    }

    @Override
    public void execute(final Workspace frame, final View view, final Location at) {
        final OneToManyFieldElement content = (OneToManyFieldElement) view.getContent();
        content.clear();
    }
}
// Copyright (c) Naked Objects Group Ltd.
