package org.nakedobjects.plugins.dndviewer.viewer.tree;

import org.nakedobjects.plugins.dndviewer.CompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.SubviewSpec;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewBuilder;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;


public abstract class CompositeNodeSpecification extends NodeSpecification implements CompositeViewSpecification, SubviewSpec {
    protected ViewBuilder builder;
    private NodeSpecification collectionLeafNodeSpecification;
    private NodeSpecification objectLeafNodeSpecification;

    public void setCollectionSubNodeSpecification(final NodeSpecification collectionLeafNodeSpecification) {
        this.collectionLeafNodeSpecification = collectionLeafNodeSpecification;
    }

    public void setObjectSubNodeSpecification(final NodeSpecification objectLeafNodeSpecification) {
        this.objectLeafNodeSpecification = objectLeafNodeSpecification;
    }

    @Override
    protected View createNodeView(final Content content, final ViewAxis axis) {
        return builder.createCompositeView(content, this, axis);
    }

    public View decorateSubview(final View view) {
        return view;
    }

    public ViewBuilder getSubviewBuilder() {
        return builder;
    }

    public View createSubview(final Content content, final ViewAxis axis, int fieldNumber) {
        ViewRequirement requirement = new ViewRequirement(content, axis, ViewRequirement.CLOSED);
        if (collectionLeafNodeSpecification.canDisplay(content, requirement )) {
            return collectionLeafNodeSpecification.createView(content, axis);
        }

        if (objectLeafNodeSpecification.canDisplay(content, requirement)) {
            return objectLeafNodeSpecification.createView(content, axis);
        }

        return null;
    }
}
// Copyright (c) Naked Objects Group Ltd.
