package org.nakedobjects.plugins.dndviewer.viewer.view.form;

import org.nakedobjects.metamodel.commons.exceptions.UnknownTypeException;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.LabelAxis;
import org.nakedobjects.plugins.dndviewer.SubviewSpec;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewFactory;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractCompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.builder.ObjectFieldBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.builder.StackLayout;


public abstract class AbstractFormSpecification extends AbstractCompositeViewSpecification implements SubviewSpec {

    public AbstractFormSpecification() {
        builder = new StackLayout(new ObjectFieldBuilder(this), false);
    }

    public boolean canDisplay(final Content content, ViewRequirement requirement) {
        return content.isObject() && requirement.is(ViewRequirement.OPEN);
    }

    public String getName() {
        return "Form";
    }

    @Override
    protected ViewAxis axis(Content content) {
        return new LabelAxis();
    }

    public View createSubview(final Content content, final ViewAxis axis, int sequence) {
        final ViewFactory factory = Toolkit.getViewFactory();

        int requirement = 0;
        if (content.isObject()) {
            requirement = objectRequirement();
        } else if (content.isTextParseable()) {
            requirement = textParseableRequirement();
        } else if (content.isCollection()) {
            requirement = collectionRequirement();
        } else {
            throw new UnknownTypeException(content);
        }

        if (requirement != 0 && include(content, sequence)) {
            ViewRequirement viewRequirement = new ViewRequirement(content, axis, requirement);
            return factory.createView(viewRequirement);
        } else {
            return null;
        }
    }

    protected boolean include(Content content, int sequence) {
        return true;
    }

    protected int objectRequirement() {
        return ViewRequirement.CLOSED | ViewRequirement.SUBVIEW;
    }

    protected int textParseableRequirement() {
        return ViewRequirement.CLOSED | ViewRequirement.SUBVIEW;
    }

    protected int collectionRequirement() {
        return ViewRequirement.CLOSED | ViewRequirement.SUBVIEW;
    }
}

// Copyright (c) Naked Objects Group Ltd.
