/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.drawing;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Shape;

public class ShapeTest
extends TestCase {
    private Shape shape;

    public static void main(String[] args) {
        TestRunner.run(ShapeTest.class);
    }

    protected void setUp() throws Exception {
        this.shape = new Shape();
    }

    public void testNew() {
        ShapeTest.assertEquals((int)0, (int)this.shape.count());
        ShapeTest.assertEquals((int)0, (int)this.shape.getX().length);
        ShapeTest.assertEquals((int)0, (int)this.shape.getY().length);
    }

    public void testAddPoint() {
        this.shape.addVertex(10, 12);
        ShapeTest.assertEquals((int)1, (int)this.shape.count());
        ShapeTest.assertEquals((int)10, (int)this.shape.getX()[0]);
        ShapeTest.assertEquals((int)12, (int)this.shape.getY()[0]);
    }

    public void testAddThreePoints() {
        this.shape.addVertex(10, 12);
        this.shape.addVertex(8, 5);
        this.shape.addVertex(0, 2);
        ShapeTest.assertEquals((int)3, (int)this.shape.count());
        ShapeTest.assertEquals((int)10, (int)this.shape.getX()[0]);
        ShapeTest.assertEquals((int)12, (int)this.shape.getY()[0]);
        ShapeTest.assertEquals((int)8, (int)this.shape.getX()[1]);
        ShapeTest.assertEquals((int)5, (int)this.shape.getY()[1]);
        ShapeTest.assertEquals((int)0, (int)this.shape.getX()[2]);
        ShapeTest.assertEquals((int)2, (int)this.shape.getY()[2]);
    }

    public void testCreateCopy() {
        this.shape.addVertex(10, 12);
        this.shape.addVertex(8, 5);
        this.shape.addVertex(0, 2);
        Shape copy = new Shape(this.shape);
        ShapeTest.assertEquals((int)3, (int)copy.count());
        ShapeTest.assertEquals((int)10, (int)copy.getX()[0]);
        ShapeTest.assertEquals((int)12, (int)copy.getY()[0]);
        ShapeTest.assertEquals((int)8, (int)copy.getX()[1]);
        ShapeTest.assertEquals((int)5, (int)copy.getY()[1]);
        ShapeTest.assertEquals((int)0, (int)copy.getX()[2]);
        ShapeTest.assertEquals((int)2, (int)copy.getY()[2]);
    }

    public void testTransform() {
        this.shape.addVertex(10, 12);
        this.shape.addVertex(8, 5);
        this.shape.addVertex(0, 2);
        this.shape.translate(10, 20);
        ShapeTest.assertEquals((int)3, (int)this.shape.count());
        ShapeTest.assertEquals((int)20, (int)this.shape.getX()[0]);
        ShapeTest.assertEquals((int)32, (int)this.shape.getY()[0]);
        ShapeTest.assertEquals((int)18, (int)this.shape.getX()[1]);
        ShapeTest.assertEquals((int)25, (int)this.shape.getY()[1]);
        ShapeTest.assertEquals((int)10, (int)this.shape.getX()[2]);
        ShapeTest.assertEquals((int)22, (int)this.shape.getY()[2]);
    }
}

