/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class AwtText
implements Text {
    private static final String ASCENT_ADJUST = "nakedobjects.viewer.dnd.ascent-adjust";
    private static final String FONT_PROPERTY_STEM = "nakedobjects.viewer.dnd.font.";
    private static final Logger LOG = Logger.getLogger(AwtText.class);
    private static final String SPACING_PROPERTYSTEM = "nakedobjects.viewer.dnd.spacing.";
    private final boolean ascentAdjust;
    private Font font;
    private final Frame fontMetricsComponent = new Frame();
    private final int lineSpacing;
    private int maxCharWidth;
    private final FontMetrics metrics;
    private final String propertyName;
    private final Hashtable stringWidthByString = new Hashtable();

    protected AwtText(String propertyName, String defaultFont) {
        NakedObjectConfiguration cfg = NakedObjectsContext.getConfiguration();
        this.font = cfg.getFont(FONT_PROPERTY_STEM + propertyName, Font.decode(defaultFont));
        LOG.info((Object)("font " + propertyName + " loaded as " + this.font));
        this.propertyName = propertyName;
        if (this.font == null) {
            this.font = cfg.getFont("nakedobjects.viewer.dnd.font.default", new Font("SansSerif", 0, 12));
        }
        this.metrics = this.fontMetricsComponent.getFontMetrics(this.font);
        this.maxCharWidth = this.metrics.getMaxAdvance() + 1;
        if (this.maxCharWidth == 0) {
            this.maxCharWidth = this.charWidth('X') + 3;
        }
        this.lineSpacing = cfg.getInteger(SPACING_PROPERTYSTEM + propertyName, 0);
        this.ascentAdjust = cfg.getBoolean(ASCENT_ADJUST, false);
        LOG.debug((Object)("font " + propertyName + " height=" + this.metrics.getHeight() + ", leading=" + this.metrics.getLeading() + ", ascent=" + this.metrics.getAscent() + ", descent=" + this.metrics.getDescent() + ", line spacing=" + this.lineSpacing));
    }

    public int charWidth(char c) {
        return this.metrics.charWidth(c);
    }

    public int getAscent() {
        return this.metrics.getAscent() - (this.ascentAdjust ? this.metrics.getDescent() : 0);
    }

    public Font getAwtFont() {
        return this.font;
    }

    public int getDescent() {
        return this.metrics.getDescent();
    }

    public int getLineHeight() {
        return this.metrics.getHeight() + this.getLineSpacing();
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public String getName() {
        return this.propertyName;
    }

    public int getMidPoint() {
        return this.getAscent() / 2;
    }

    public int getTextHeight() {
        return this.metrics.getHeight() - (this.ascentAdjust ? this.metrics.getDescent() : 0);
    }

    public int stringHeight(String text, int maxWidth) {
        int noLines = 0;
        StringTokenizer lines = new StringTokenizer(text, "\n\r");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            StringTokenizer words = new StringTokenizer(line, " ");
            StringBuffer l = new StringBuffer();
            int width = 0;
            while (words.hasMoreTokens()) {
                String nextWord = words.nextToken();
                int wordWidth = this.stringWidth(nextWord);
                if ((width += wordWidth) >= maxWidth) {
                    ++noLines;
                    l.setLength(0);
                    width = wordWidth;
                }
                l.append(nextWord);
                l.append(" ");
                width += this.stringWidth(" ");
            }
            ++noLines;
        }
        return noLines * this.getLineHeight();
    }

    public int stringWidth(String text, int maxWidth) {
        int width = 0;
        StringTokenizer lines = new StringTokenizer(text, "\n\r");
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            StringTokenizer words = new StringTokenizer(line, " ");
            StringBuffer l = new StringBuffer();
            int lineWidth = 0;
            while (words.hasMoreTokens()) {
                String nextWord = words.nextToken();
                int wordWidth = this.stringWidth(nextWord);
                if ((lineWidth += wordWidth) >= maxWidth) {
                    return maxWidth;
                }
                if (lineWidth > width) {
                    width = lineWidth;
                }
                l.append(nextWord);
                l.append(" ");
                lineWidth += this.stringWidth(" ");
            }
        }
        return width;
    }

    public int stringWidth(String text) {
        int[] cachedStringWidth = (int[])this.stringWidthByString.get(text);
        if (cachedStringWidth == null) {
            cachedStringWidth = new int[]{this.stringWidthInternal(text)};
            this.stringWidthByString.put(text, cachedStringWidth);
        }
        return cachedStringWidth[0];
    }

    private int stringWidthInternal(String text) {
        int stringWidth = this.metrics.stringWidth(text);
        if (stringWidth > text.length() * this.maxCharWidth) {
            LOG.debug((Object)("spurious width of string; calculating manually: " + stringWidth + " for " + this + ": " + text));
            stringWidth = 0;
            for (int i = 0; i < text.length(); ++i) {
                int charWidth = this.charWidth(text.charAt(i));
                if (charWidth > this.maxCharWidth) {
                    LOG.debug((Object)("spurious width of character; using max width: " + charWidth + " for " + text.charAt(i)));
                    charWidth = this.maxCharWidth;
                }
                LOG.debug((Object)(i + " " + (stringWidth += charWidth)));
            }
        }
        return stringWidth;
    }

    public String toString() {
        return this.font.toString();
    }
}

