/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer;

import java.awt.event.KeyEvent;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.plugins.dndviewer.FocusManager;
import org.nakedobjects.plugins.dndviewer.KeyboardAction;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.viewer.XViewer;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;

public class KeyboardManager {
    private static final Logger LOG = Logger.getLogger(KeyboardManager.class);
    private final XViewer viewer;
    private FocusManager focusManager;

    public KeyboardManager(XViewer viewer) {
        this.viewer = viewer;
    }

    private View getFocus() {
        return this.focusManager == null ? null : this.focusManager.getFocus();
    }

    public void pressed(int keyCode, int modifiers) {
        if (this.ignoreKey(keyCode)) {
            return;
        }
        LOG.debug((Object)("key " + KeyEvent.getKeyModifiersText(modifiers) + " '" + KeyEvent.getKeyText(keyCode) + "' pressed"));
        KeyboardAction keyboardAction = new KeyboardAction(keyCode, modifiers);
        if (this.viewer.isOverlayAvailable()) {
            this.viewer.getOverlayView().keyPressed(keyboardAction);
            if (!keyboardAction.isConsumed() && keyCode == 112) {
                this.viewer.openHelp(this.viewer.getOverlayView());
            }
            return;
        }
        View keyboardFocus = this.getFocus();
        if (keyboardFocus == null) {
            LOG.debug((Object)"No focus set");
            return;
        }
        keyboardFocus.keyPressed(keyboardAction);
        if (keyboardAction.isConsumed()) {
            return;
        }
        if ((modifiers & 1) == 1 && keyCode == 121) {
            Location location = keyboardFocus.getAbsoluteLocation();
            location.add(20, 14);
            this.viewer.popupMenu(keyboardFocus, location, true, false, false);
            return;
        }
        if (keyCode == 121) {
            Location location = keyboardFocus.getAbsoluteLocation();
            location.add(20, 14);
            this.viewer.popupMenu(keyboardFocus, location, false, false, false);
            return;
        }
        if (keyCode == 115 && (modifiers & 2) == 2) {
            return;
        }
        if (keyCode == 40) {
            this.focusManager.focusFirstChildView();
            return;
        }
        if (keyCode == 38) {
            this.focusManager.focusParentView();
            return;
        }
        if (keyCode == 36) {
            this.viewer.makeRootFocus();
            return;
        }
        if (keyCode == 39) {
            this.focusManager.focusNextView();
            return;
        }
        if (keyCode == 37) {
            this.focusManager.focusPreviousView();
            return;
        }
        int action = 0;
        if (keyCode == 112) {
            this.viewer.openHelp(keyboardFocus);
        } else if (keyCode == 9) {
            action = this.tab(modifiers);
        }
        switch (action) {
            case 2: {
                this.focusManager.focusNextView();
                break;
            }
            case 4: {
                this.focusManager.focusPreviousView();
                break;
            }
            case 3: {
                this.focusManager.focusParentView();
                break;
            }
            case 5: {
                this.focusManager.focusFirstChildView();
            }
        }
    }

    private boolean ignoreKey(int keyCode) {
        return keyCode == 16 || keyCode == 17 || keyCode == 18;
    }

    private int tab(int modifiers) {
        int action = (modifiers & 2) == 2 ? ((modifiers & 1) == 1 ? 5 : 3) : ((modifiers & 1) == 1 ? 4 : 2);
        return action;
    }

    public void released(int keyCode, int modifiers) {
        if (this.ignoreKey(keyCode)) {
            return;
        }
        LOG.debug((Object)("key " + KeyEvent.getKeyText(keyCode) + " released\n"));
        View keyboardFocus = this.getFocus();
        if (keyboardFocus != null) {
            keyboardFocus.keyReleased(keyCode, modifiers);
        }
    }

    public void typed(char keyChar) {
        LOG.debug((Object)("typed '" + keyChar + "'"));
        if (this.viewer.isOverlayAvailable()) {
            this.viewer.getOverlayView().keyTyped(keyChar);
            return;
        }
        View keyboardFocus = this.getFocus();
        if (keyboardFocus != null && !Character.isISOControl(keyChar)) {
            keyboardFocus.keyTyped(keyChar);
        }
    }

    public FocusManager getFocusManager() {
        return this.focusManager;
    }

    public void setFocusManager(FocusManager focusManager) {
        if (focusManager == null) {
            throw new NakedObjectException("No focus manager set up");
        }
        this.focusManager = focusManager;
    }
}

