/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import org.apache.log4j.Logger;
import org.nakedobjects.plugins.dndviewer.viewer.ViewerFrame;

class ShutdownDialog
extends Dialog
implements ActionListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ShutdownDialog.class);
    private static final int BORDER = 10;
    private Button cancel;
    private Button quit;
    private static String CANCEL_LABEL = "Cancel";
    private static String QUIT_LABEL = "Ok";

    public ShutdownDialog(ViewerFrame owner) {
        super(owner, "Naked Objects", true);
        this.setLayout(new GridLayout(2, 3, 10, 10));
        this.add(new Label("Exit Naked Objects?", 0));
        this.add(new Panel());
        this.add(new Panel());
        this.add(new Panel());
        this.quit = new Button(QUIT_LABEL);
        this.add(this.quit);
        this.quit.addActionListener(this);
        this.quit.addKeyListener(this);
        this.cancel = new Button(CANCEL_LABEL);
        this.add(this.cancel);
        this.cancel.addActionListener(this);
        this.cancel.addKeyListener(this);
        this.pack();
        int width = this.getSize().width;
        int height = this.getSize().height;
        Dimension screen = owner.getSize();
        Point point = owner.getLocation();
        int x = point.x + screen.width / 2 - width / 2;
        int y = point.y + screen.height / 2 - height / 2;
        this.setLocation(x, y);
        this.setVisible(true);
        this.quit.requestFocus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ShutdownDialog.this.dispose();
            }
        });
    }

    public Insets getInsets() {
        Insets in = super.getInsets();
        in.top += 10;
        in.bottom += 10;
        in.left += 10;
        in.right += 10;
        return in;
    }

    public void actionPerformed(ActionEvent evt) {
        this.action(evt.getSource());
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.action(e.getComponent());
        }
        if (e.getKeyCode() == 27) {
            this.cancel(e.getComponent());
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    private synchronized void cancel(Object widget) {
        this.dispose();
    }

    private synchronized void action(Object widget) {
        if (widget == this.cancel) {
            this.cancel(widget);
        } else if (widget == this.quit) {
            this.quit();
        }
    }

    private void quit() {
        this.dispose();
        ((ViewerFrame)this.getParent()).quit();
    }

    public void dispose() {
        LOG.debug((Object)"dispose...");
        super.dispose();
        LOG.debug((Object)"...disposed");
    }
}

