/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.action;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.plugins.dndviewer.ObjectContent;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;
import org.nakedobjects.runtime.transaction.updatenotifier.UpdateNotifier;

public class DisposeObjectOption
extends AbstractUserAction {
    public DisposeObjectOption() {
        super("Dispose Object", EXPLORATION);
    }

    public Consent disabled(View view) {
        NakedObject adapter = view.getContent().getNaked();
        if (adapter.getResolveState().isDestroyed()) {
            return new Veto("Can't do anything with a destroyed object");
        }
        if (this.isObjectInRootView(view)) {
            return Allow.DEFAULT;
        }
        return new Veto("Can't dispose an object from within another view.");
    }

    private boolean isObjectInRootView(View view) {
        View rootView = this.rootView(view);
        return view.getContent() == rootView.getContent();
    }

    private View rootView(View view) {
        View parent = view.getParent();
        if (view.getWorkspace() == parent) {
            return view;
        }
        return this.rootView(parent);
    }

    public void execute(Workspace workspace, View view, Location at) {
        NakedObject object = ((ObjectContent)view.getContent()).getObject();
        DisposeObjectOption.getPersistenceSession().destroyObject(object);
        DisposeObjectOption.getUpdateNotifier().addDisposedObject(object);
        view.getViewManager().disposeUnneededViews();
        view.getFeedbackManager().showMessagesAndWarnings();
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static NakedObjectTransactionManager getTransactionManager() {
        return DisposeObjectOption.getPersistenceSession().getTransactionManager();
    }

    private static UpdateNotifier getUpdateNotifier() {
        return NakedObjectsContext.getUpdateNotifier();
    }
}

