/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.action;

import org.apache.log4j.Logger;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;

public class OpenViewOption
extends AbstractUserAction {
    private static final Logger LOG = Logger.getLogger(OpenViewOption.class);
    private final ViewSpecification specification;

    public OpenViewOption(ViewSpecification builder) {
        super("Open as " + builder.getName());
        this.specification = builder;
    }

    public void execute(Workspace workspace, View view, Location at) {
        View newView = this.specification.createView(view.getContent(), null);
        LOG.debug((Object)("open view " + newView));
        newView.setLocation(at);
        workspace.addWindow(newView);
        workspace.markDamaged();
    }

    public String getDescription(View view) {
        String title = view.getContent().title();
        return "Open '" + title + "' in a " + this.specification.getName() + " window";
    }

    public String toString() {
        return super.toString() + " [prototype=" + this.specification.getName() + "]";
    }
}

