/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.action;

import org.apache.log4j.Logger;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;

public class ReplaceViewOption
extends AbstractUserAction {
    private static final Logger LOG = Logger.getLogger(ReplaceViewOption.class);
    private final ViewSpecification specification;

    public ReplaceViewOption(ViewSpecification specification) {
        super("View as " + specification.getName());
        this.specification = specification;
    }

    public String getDescription(View view) {
        return "Replace this " + view.getSpecification().getName() + " view with a " + this.specification.getName() + " view";
    }

    public void execute(Workspace workspace, View view, Location at) {
        View replacement = this.specification.createView(view.getContent(), view.getViewAxis());
        LOG.debug((Object)("replacement view " + replacement));
        view.getParent().replaceView(view.getView(), replacement);
    }

    public String toString() {
        return super.toString() + " [prototype=" + this.specification.getName() + "]";
    }
}

