/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.NakedObjectList;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionConstants;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.CompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.ObjectContent;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewDrag;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.basic.ApplicationWorkspaceBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.border.DialogBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.WindowBorder;
import org.nakedobjects.plugins.dndviewer.viewer.content.PerspectiveContent;
import org.nakedobjects.plugins.dndviewer.viewer.content.ServiceObject;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Padding;
import org.nakedobjects.plugins.dndviewer.viewer.focus.SubviewFocusManager;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.CompositeViewBuilder;
import org.nakedobjects.runtime.authentication.standard.MultiUserExplorationSession;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.persistence.adaptermanager.AdapterManager;
import org.nakedobjects.runtime.userprofile.PerspectiveEntry;

public final class ApplicationWorkspace
extends CompositeViewBuilder
implements Workspace {
    protected Vector<View> serviceViews = new Vector();
    protected Vector<View> iconViews = new Vector();

    public ApplicationWorkspace(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        super(content, specification, axis);
    }

    public void addDialog(View dialogContent) {
        DialogBorder dialogView = new DialogBorder(dialogContent, false);
        this.addView(dialogView);
    }

    public void addWindow(View containedView) {
        WindowBorder windowView = new WindowBorder(containedView, false);
        this.addView(windowView);
        windowView.setFocusManager(new SubviewFocusManager(windowView));
    }

    public void addView(View view) {
        super.addView(view);
        this.getViewManager().setKeyboardFocus(view);
        view.getFocusManager().focusFirstChildView();
    }

    public void replaceView(View toReplace, View replacement) {
        if (replacement.getSpecification().isOpen()) {
            WindowBorder windowView = new WindowBorder(replacement, false);
            super.replaceView(toReplace, windowView);
        } else {
            super.replaceView(toReplace, replacement);
        }
    }

    public View addWindowFor(NakedObject object, Location at) {
        Content content = Toolkit.getContentFactory().createRootContent(object);
        View view = Toolkit.getViewFactory().createView(new ViewRequirement(content, 4));
        view.setLocation(at);
        this.addWindow(view);
        return view;
    }

    public View addIconFor(NakedObject object, Location at) {
        Content content = Toolkit.getContentFactory().createRootContent(object);
        View icon = Toolkit.getViewFactory().createView(new ViewRequirement(content, 8193));
        this.add(this.iconViews, icon);
        icon.setLocation(at);
        return icon;
    }

    public void addServiceIconFor(NakedObject service) {
        ServiceObject content = new ServiceObject(service);
        View serviceIcon = Toolkit.getViewFactory().createView(new ViewRequirement(content, 8193));
        this.add(this.serviceViews, serviceIcon);
    }

    public Drag dragStart(DragStart drag) {
        View subview = this.subviewFor(drag.getLocation());
        if (subview != null) {
            drag.subtract(subview.getLocation());
            return subview.dragStart(drag);
        }
        return null;
    }

    public void drop(ContentDrag drag) {
        this.getFeedbackManager().showDefaultCursor();
        if (!drag.getSourceContent().isObject()) {
            return;
        }
        if (drag.getSourceContent().getNaked() == this.getPerspective()) {
            this.getFeedbackManager().setAction("can' drop self on workspace");
            return;
        }
        NakedObject source = ((ObjectContent)drag.getSourceContent()).getObject();
        if (source.getSpecification().isService()) {
            this.getPerspective().addToServices(source.getObject());
            this.invalidateContent();
        } else if (!drag.isShift()) {
            this.getPerspective().addToObjects(source.getObject());
        }
        if (source.getSpecification().isService()) {
            return;
        }
        Location dropLocation = drag.getTargetLocation();
        dropLocation.subtract(drag.getOffset());
        if (drag.isShift()) {
            View newView = this.createSubviewFor(source, false);
            drag.getTargetView().addView(newView);
            newView.setLocation(dropLocation);
        } else {
            View sourceView = drag.getSource();
            if (!sourceView.getSpecification().isOpen()) {
                View[] subviews = this.getSubviews();
                for (int i = 0; i < subviews.length; ++i) {
                    if (subviews[i] != sourceView) continue;
                    sourceView.markDamaged();
                    sourceView.setLocation(dropLocation);
                    sourceView.markDamaged();
                    return;
                }
            } else {
                for (View view : this.iconViews) {
                    if (view.getContent().getNaked() != source) continue;
                    view.markDamaged();
                    view.setLocation(dropLocation);
                    view.markDamaged();
                    return;
                }
            }
            this.addIconFor(source, dropLocation);
        }
    }

    public void entered() {
    }

    private PerspectiveEntry getPerspective() {
        return ((PerspectiveContent)this.getContent()).getPerspective();
    }

    public View createSubviewFor(NakedObject object, boolean asIcon) {
        Content content = Toolkit.getContentFactory().createRootContent(object);
        View view = asIcon ? Toolkit.getViewFactory().createView(new ViewRequirement(content, 8193)) : Toolkit.getViewFactory().createView(new ViewRequirement(content, 8196));
        return view;
    }

    public void drop(ViewDrag drag) {
        this.getFeedbackManager().showDefaultCursor();
        View sourceView = drag.getSourceView();
        if (sourceView.getSpecification() != null && sourceView.getSpecification().isSubView()) {
            if (!sourceView.getSpecification().isOpen() || !sourceView.getSpecification().isReplaceable()) {
                Location newLocation = drag.getViewDropLocation();
                this.addWindowFor(sourceView.getContent().getNaked(), newLocation);
                sourceView.getState().clearViewIdentified();
            }
        } else {
            sourceView.markDamaged();
            Location newLocation = drag.getViewDropLocation();
            sourceView.setLocation(newLocation);
            sourceView.limitBoundsWithin(this.getSize());
            sourceView.markDamaged();
        }
    }

    public Padding getPadding() {
        return new Padding();
    }

    public Workspace getWorkspace() {
        return this;
    }

    public void lower(View view) {
        if (this.views.contains(view)) {
            this.views.removeElement(view);
            this.views.insertElementAt(view, 0);
            this.markDamaged();
        }
    }

    public void raise(View view) {
        if (this.views.contains(view)) {
            this.views.removeElement(view);
            this.views.addElement(view);
            this.markDamaged();
        }
    }

    public void removeView(View view) {
        view.markDamaged();
        if (this.iconViews.contains(view)) {
            this.iconViews.remove(view);
            this.getViewManager().removeFromNotificationList(view);
            this.removeObject(view.getContent().getNaked());
        } else if (this.serviceViews.contains(view)) {
            this.serviceViews.remove(view);
            this.getViewManager().removeFromNotificationList(view);
            this.removeService(view.getContent().getNaked());
        } else {
            super.removeView(view);
        }
    }

    private void removeService(NakedObject object) {
        this.getPerspective().removeFromServices(object.getObject());
    }

    private void removeObject(NakedObject object) {
        this.getPerspective().removeFromObjects(object.getObject());
    }

    public void removeViewsFor(NakedObject object) {
        View[] views = this.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            View view = views[i];
            if (view.getContent().getNaked() != object) continue;
            view.dispose();
        }
    }

    public void secondClick(Click click) {
        View subview = this.subviewFor(click.getLocation());
        if (subview != null) {
            super.secondClick(click);
        }
    }

    public String toString() {
        return "Workspace" + this.getId();
    }

    public void viewMenuOptions(UserActionSet options) {
        options.setColor(Toolkit.getColor("color.background.menu.workspace"));
        options.add(new AbstractUserAction("Close all"){

            public void execute(Workspace workspace, View view, Location at) {
                View[] views = ApplicationWorkspace.this.getWindowViews();
                for (int i = 0; i < views.length; ++i) {
                    View v = views[i];
                    v.dispose();
                }
                ApplicationWorkspace.this.markDamaged();
            }
        });
        options.add(new AbstractUserAction("Tidy up windows"){

            public void execute(Workspace workspace, View view, Location at) {
                ApplicationWorkspace.this.tidyViews(ApplicationWorkspace.this.getWindowViews());
            }
        });
        options.add(new AbstractUserAction("Tidy up icons"){

            public void execute(Workspace workspace, View view, Location at) {
                ApplicationWorkspace.this.tidyViews(ApplicationWorkspace.this.getObjectIconViews());
            }
        });
        options.add(new AbstractUserAction("Tidy up all"){

            public void execute(Workspace workspace, View view, Location at) {
                ApplicationWorkspace.this.tidyViews(ApplicationWorkspace.this.getObjectIconViews());
                ApplicationWorkspace.this.tidyViews(ApplicationWorkspace.this.getWindowViews());
            }
        });
        options.add(new AbstractUserAction("Services..."){

            public void execute(Workspace workspace, View view, Location at) {
                List services = NakedObjectsContext.getServices();
                NakedObject[] serviceObjects = new NakedObject[services.size()];
                int i = 0;
                for (Object object : services) {
                    AdapterManager adapterManager = NakedObjectsContext.getPersistenceSession().getAdapterManager();
                    serviceObjects[i++] = adapterManager.adapterFor(object);
                }
                NakedObjectSpecification spec = ApplicationWorkspace.this.getSpecificationLoader().loadSpecification(Object.class);
                NakedObjectList collection = new NakedObjectList(spec, serviceObjects);
                ApplicationWorkspace.this.addWindowFor(ApplicationWorkspace.this.getAdapterManager().adapterFor((Object)collection), at);
            }
        });
        this.menuForChangingUsers(options);
    }

    private void menuForChangingUsers(UserActionSet options) {
        MultiUserExplorationSession session;
        if (this.getAuthenticationSession() instanceof MultiUserExplorationSession && (session = (MultiUserExplorationSession)this.getAuthenticationSession()).hasMultipleUsers()) {
            List users = session.getUserNames();
            UserActionSet set = new UserActionSet("Change user", options, NakedObjectActionConstants.EXPLORATION);
            for (String user : users) {
                this.menuOptionForChangingUser(set, user, session.getUserName());
            }
            options.add(set);
        }
    }

    private void menuOptionForChangingUser(UserActionSet set, final String user, final String currentUser) {
        set.add(new AbstractUserAction(user){

            public void execute(Workspace workspace, View view, Location at) {
                MultiUserExplorationSession session = (MultiUserExplorationSession)ApplicationWorkspace.this.getAuthenticationSession();
                session.setCurrentSession(user);
            }

            public Consent disabled(View view) {
                return user.equals(currentUser) ? new Veto("Current user") : Allow.DEFAULT;
            }
        });
    }

    protected View[] subviews() {
        View[] v = new View[this.views.size() + this.serviceViews.size() + this.iconViews.size()];
        int offset = 0;
        Object[] src = this.serviceViews.toArray();
        System.arraycopy(src, 0, v, offset, src.length);
        offset += src.length;
        src = this.iconViews.toArray();
        System.arraycopy(src, 0, v, offset, src.length);
        offset += src.length;
        src = this.views.toArray();
        System.arraycopy(src, 0, v, offset, src.length);
        return v;
    }

    public void clearServiceViews() {
        Enumeration<View> e = this.serviceViews.elements();
        while (e.hasMoreElements()) {
            View view = e.nextElement();
            view.markDamaged();
        }
        this.serviceViews.clear();
    }

    protected View[] getWindowViews() {
        return this.createArrayOfViews(this.views);
    }

    private View[] createArrayOfViews(Vector views) {
        Object[] array = new View[views.size()];
        views.copyInto(array);
        return array;
    }

    protected View[] getServiceIconViews() {
        return this.createArrayOfViews(this.serviceViews);
    }

    protected View[] getObjectIconViews() {
        return this.createArrayOfViews(this.iconViews);
    }

    private void tidyViews(View[] views) {
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            v.setLocation(ApplicationWorkspaceBuilder.UNPLACED);
        }
        this.invalidateLayout();
        this.markDamaged();
    }

    private SpecificationLoader getSpecificationLoader() {
        return NakedObjectsContext.getSpecificationLoader();
    }

    private PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    private AuthenticationSession getAuthenticationSession() {
        return NakedObjectsContext.getAuthenticationSession();
    }
}

