/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.exceptions.NotYetImplementedException;
import org.nakedobjects.metamodel.facets.hide.HiddenFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.dndviewer.CompositeViewSpecification;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.viewer.basic.ApplicationWorkspace;
import org.nakedobjects.plugins.dndviewer.viewer.basic.MinimizedView;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractViewBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.content.PerspectiveContent;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.userprofile.PerspectiveEntry;

public class ApplicationWorkspaceBuilder
extends AbstractViewBuilder {
    private static final Logger LOG = Logger.getLogger(ApplicationWorkspaceBuilder.class);
    private static final int PADDING = 10;
    public static final Location UNPLACED = new Location(-1, -1);

    public void build(View view1) {
        NakedObject adapter;
        ApplicationWorkspace workspace = (ApplicationWorkspace)view1;
        PerspectiveContent perspectiveContent = (PerspectiveContent)view1.getContent();
        workspace.clearServiceViews();
        PerspectiveEntry perspective = perspectiveContent.getPerspective();
        for (Object object : perspective.getObjects()) {
            adapter = NakedObjectsContext.getPersistenceSession().getAdapterManager().adapterFor(object);
            workspace.addIconFor(adapter, UNPLACED);
        }
        for (Object service : perspective.getServices()) {
            adapter = NakedObjectsContext.getPersistenceSession().getAdapterManager().adapterFor(service);
            if (this.isHidden(adapter)) continue;
            workspace.addServiceIconFor(adapter);
        }
    }

    private boolean isHidden(NakedObject serviceNO) {
        NakedObjectSpecification serviceNoSpec = serviceNO.getSpecification();
        return serviceNoSpec.getFacet(HiddenFacet.class) != null;
    }

    public boolean canDisplay(NakedObject object) {
        return object instanceof NakedObject && object != null;
    }

    public Size getRequiredSize(View view) {
        return new Size(600, 400);
    }

    public String getName() {
        return "Simple Workspace";
    }

    public void layout(View view1, Size maximumSize) {
        ApplicationWorkspace view = (ApplicationWorkspace)view1;
        int widthUsed = this.layoutServiceIcons(maximumSize, view);
        this.layoutObjectIcons(maximumSize, view);
        this.layoutWindowViews(maximumSize, view, widthUsed);
    }

    private void layoutWindowViews(Size maximumSize, ApplicationWorkspace view, int xOffset) {
        int i;
        Size size = view.getSize();
        size.contract(view.getPadding());
        int maxHeight = size.getHeight();
        int maxWidth = size.getWidth();
        int xWindow = xOffset + 10;
        int yWindow = 10;
        int xMinimized = 1;
        int yMinimized = maxHeight - 1;
        View[] views = view.getWindowViews();
        for (i = 0; i < views.length; ++i) {
            View subview = views[i];
            subview.layout(new Size(maximumSize));
        }
        for (i = 0; i < views.length; ++i) {
            View v = views[i];
            Size componentSize = v.getRequiredSize(new Size(size));
            v.setSize(componentSize);
            if (v instanceof MinimizedView) {
                Size s = v.getMaximumSize();
                if (xMinimized + s.getWidth() > maxWidth) {
                    xMinimized = 1;
                    yMinimized -= s.getHeight() + 1;
                }
                v.setLocation(new Location(xMinimized, yMinimized - s.getHeight()));
                xMinimized += s.getWidth() + 1;
            } else if (v.getLocation().equals(UNPLACED)) {
                int height = componentSize.getHeight() + 6;
                v.setLocation(new Location(xWindow, yWindow));
                yWindow += height;
            }
            v.limitBoundsWithin(maximumSize);
        }
    }

    private int layoutServiceIcons(Size maximumSize, ApplicationWorkspace view) {
        Size size = view.getSize();
        size.contract(view.getPadding());
        int maxHeight = size.getHeight();
        int xService = 10;
        int yService = 10;
        int maxServiceWidth = 0;
        View[] views = view.getServiceIconViews();
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            Size componentSize = v.getRequiredSize(new Size(size));
            v.setSize(componentSize);
            int height = componentSize.getHeight() + 6;
            NakedObject object = v.getContent().getNaked();
            if (object.getSpecification().isService()) {
                if (yService + height > maxHeight) {
                    yService = 10;
                    xService += maxServiceWidth + 10;
                    maxServiceWidth = 0;
                    LOG.debug((Object)("creating new column at " + xService + ", " + yService));
                }
                LOG.debug((Object)("service icon at " + xService + ", " + yService));
                v.setLocation(new Location(xService, yService));
                maxServiceWidth = Math.max(maxServiceWidth, componentSize.getWidth());
                yService += height;
            }
            v.limitBoundsWithin(maximumSize);
        }
        return xService + maxServiceWidth;
    }

    private void layoutObjectIcons(Size maximumSize, ApplicationWorkspace view) {
        Size size = view.getSize();
        size.contract(view.getPadding());
        int maxWidth = size.getWidth();
        int xObject = maxWidth - 10;
        int yObject = 10;
        View[] views = view.getObjectIconViews();
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            Size componentSize = v.getRequiredSize(new Size(size));
            v.setSize(componentSize);
            if (v.getLocation().equals(UNPLACED)) {
                int height = componentSize.getHeight() + 6;
                v.setLocation(new Location(xObject - componentSize.getWidth(), yObject));
                yObject += height;
            }
            v.limitBoundsWithin(maximumSize);
        }
    }

    public View createCompositeView(Content content, CompositeViewSpecification specification, ViewAxis axis) {
        throw new NotYetImplementedException();
    }
}

