/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.basic;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.ContentDrag;
import org.nakedobjects.plugins.dndviewer.ObjectContent;
import org.nakedobjects.plugins.dndviewer.ObjectParameter;
import org.nakedobjects.plugins.dndviewer.OneToOneField;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewAxis;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.viewer.basic.EmptyFieldTitleText;
import org.nakedobjects.plugins.dndviewer.viewer.border.ObjectBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Text;
import org.nakedobjects.plugins.dndviewer.viewer.lookup.OpenObjectDropDownBorder;
import org.nakedobjects.plugins.dndviewer.viewer.view.graphic.IconGraphic;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.AbstractView;
import org.nakedobjects.plugins.dndviewer.viewer.view.text.TitleText;

public class EmptyField
extends AbstractView {
    private final IconGraphic icon;
    private final TitleText text;

    public EmptyField(Content content, ViewSpecification specification, ViewAxis axis, Text style) {
        super(content, specification, axis);
        if (((ObjectContent)content).getObject() != null) {
            throw new IllegalArgumentException("Content for EmptyField must be null: " + content);
        }
        NakedObject object = ((ObjectContent)this.getContent()).getObject();
        if (object != null) {
            throw new IllegalArgumentException("Content for EmptyField must be null: " + object);
        }
        this.icon = new IconGraphic((View)this, style);
        this.text = new EmptyFieldTitleText(this, style);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        int x = 0;
        int y = this.icon.getBaseline();
        this.icon.draw(canvas, x, y);
        x += this.icon.getSize().getWidth();
        this.text.draw(canvas, x += View.HPADDING, y);
    }

    public int getBaseline() {
        return this.icon.getBaseline();
    }

    public Size getMaximumSize() {
        Size size = this.icon.getSize();
        size.extendWidth(View.HPADDING);
        size.extendWidth(this.text.getSize().getWidth());
        return size;
    }

    private Consent canDrop(NakedObject dragSource) {
        ObjectContent content = (ObjectContent)this.getContent();
        return content.canSet(dragSource);
    }

    public void dragIn(ContentDrag drag) {
        Content sourceContent = drag.getSourceContent();
        if (sourceContent instanceof ObjectContent) {
            NakedObject source = ((ObjectContent)sourceContent).getObject();
            Consent canDrop = this.canDrop(source);
            if (canDrop.isAllowed()) {
                this.getState().setCanDrop();
            } else {
                this.getState().setCantDrop();
            }
            String actionText = canDrop.isVetoed() ? canDrop.getReason() : "Set to " + sourceContent.title();
            this.getFeedbackManager().setAction(actionText);
        } else {
            this.getState().setCantDrop();
        }
        this.markDamaged();
    }

    public void dragOut(ContentDrag drag) {
        this.getState().clearObjectIdentified();
        this.markDamaged();
    }

    public void drop(ContentDrag drag) {
        this.getState().clearViewIdentified();
        this.markDamaged();
        NakedObject target = ((ObjectContent)this.getParent().getContent()).getObject();
        Content sourceContent = drag.getSourceContent();
        if (sourceContent instanceof ObjectContent) {
            NakedObject source = ((ObjectContent)sourceContent).getObject();
            this.setField(target, source);
        }
    }

    public void objectActionResult(NakedObject result, Location at) {
        NakedObject target = ((ObjectContent)this.getParent().getContent()).getObject();
        if (result instanceof NakedObject) {
            this.setField(target, result);
        }
        super.objectActionResult(result, at);
    }

    private void setField(NakedObject parent, NakedObject object) {
        if (this.canDrop(object).isAllowed()) {
            ((ObjectContent)this.getContent()).setObject(object);
            this.getParent().invalidateContent();
        }
    }

    public String toString() {
        return "EmptyField" + this.getId();
    }

    public static class Specification
    implements ViewSpecification {
        public boolean canDisplay(Content content, ViewRequirement requirement) {
            return content != null && content.isObject() && requirement.is(4) && !content.isTextParseable() && content.getNaked() == null;
        }

        public View createView(Content content, ViewAxis axis) {
            EmptyField emptyField = new EmptyField(content, this, axis, Toolkit.getText("text.normal"));
            if (content instanceof OneToOneField && ((OneToOneField)content).isEditable().isAllowed() || content instanceof ObjectParameter) {
                if (content.isOptionEnabled()) {
                    return new ObjectBorder(new OpenObjectDropDownBorder(emptyField));
                }
                return new ObjectBorder(emptyField);
            }
            return emptyField;
        }

        public String getName() {
            return "empty field";
        }

        public boolean isAligned() {
            return false;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReplaceable() {
            return true;
        }

        public boolean isSubView() {
            return true;
        }
    }
}

