/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewRequirement;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Shape;
import org.nakedobjects.plugins.dndviewer.viewer.view.form.InternalFormSpecification;

public class ExpandableViewBorder
extends AbstractBorder {
    private boolean isOpen = false;

    public ExpandableViewBorder(View view) {
        super(view);
        this.left = Toolkit.defaultFieldHeight();
    }

    public void draw(Canvas canvas) {
        Shape pointer;
        if (this.isOpen) {
            pointer = new Shape(2, this.left / 2);
            pointer.addVertex(this.left - 2, this.left / 2);
            pointer.addVertex(this.left / 2, this.left - 2);
        } else {
            pointer = new Shape(2, 2);
            pointer.addVertex(2, this.left - 2);
            pointer.addVertex(this.left / 2, 2 + (this.left - 2) / 2);
        }
        canvas.drawSolidShape(pointer, Toolkit.getColor("color.primary1"));
        super.draw(canvas);
    }

    public void firstClick(Click click) {
        if (click.getLocation().getX() < this.left) {
            this.isOpen = !this.isOpen;
            View parent = this.wrappedView.getParent();
            this.getViewManager().removeFromNotificationList(this.wrappedView);
            if (this.isOpen) {
                this.wrappedView = new InternalFormSpecification().createView(this.getContent(), null);
            } else {
                ViewRequirement requirement = new ViewRequirement(this.getContent(), 1);
                this.wrappedView = Toolkit.getViewFactory().createView(requirement);
            }
            this.setView(this);
            this.setParent(parent);
            this.getParent().invalidateLayout();
        } else {
            super.firstClick(click);
        }
    }
}

