/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.plugins.dndviewer.Canvas;
import org.nakedobjects.plugins.dndviewer.Click;
import org.nakedobjects.plugins.dndviewer.Drag;
import org.nakedobjects.plugins.dndviewer.DragStart;
import org.nakedobjects.plugins.dndviewer.KeyboardAction;
import org.nakedobjects.plugins.dndviewer.Toolkit;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewDrag;
import org.nakedobjects.plugins.dndviewer.ViewState;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractUserAction;
import org.nakedobjects.plugins.dndviewer.viewer.border.AbstractBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.SelectableViewAxis;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Color;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Image;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Offset;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;
import org.nakedobjects.plugins.dndviewer.viewer.image.ImageFactory;
import org.nakedobjects.plugins.dndviewer.viewer.view.simple.DragViewOutline;

public class ObjectBorder
extends AbstractBorder {
    private static final int BORDER = 13;

    public ObjectBorder(int size, View wrappedView) {
        super(wrappedView);
        this.top = size;
        this.left = size;
        this.bottom = size;
        this.right = size + 13;
    }

    public ObjectBorder(View wrappedView) {
        this(1, wrappedView);
    }

    protected void debugDetails(DebugString debug) {
        super.debugDetails(debug);
        debug.appendln("border", (Object)(this.top + " pixel(s)"));
    }

    public Drag dragStart(DragStart drag) {
        if (drag.getLocation().getX() > this.getSize().getWidth() - this.right) {
            if (this.getContent().getNaked() == null) {
                return null;
            }
            DragViewOutline dragOverlay = new DragViewOutline(this.getView());
            return new ViewDrag(this, new Offset(drag.getLocation()), dragOverlay);
        }
        return super.dragStart(drag);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        Color color = null;
        ViewState state = this.getState();
        boolean hasFocus = this.getViewManager().hasFocus(this.getView());
        if (state.canDrop()) {
            color = Toolkit.getColor("color.valid");
        } else if (state.cantDrop()) {
            color = Toolkit.getColor("color.invalid");
        } else if (hasFocus) {
            color = Toolkit.getColor("color.identified");
        } else if (state.isObjectIdentified()) {
            color = Toolkit.getColor("color.secondary2");
        }
        Size s = this.getSize();
        if (this.getContent().isPersistable() && this.getContent().isTransient()) {
            int x = s.getWidth() - 13;
            boolean y = false;
            Image icon = ImageFactory.getInstance().loadIcon("transient", 8, null);
            if (icon == null) {
                canvas.drawText("*", x, 0 + Toolkit.getText("text.normal").getAscent(), Toolkit.getColor("color.black"), Toolkit.getText("text.normal"));
            } else {
                canvas.drawImage(icon, x, 0, 12, 12);
            }
        }
        if (color != null) {
            int i;
            int xExtent;
            if (hasFocus) {
                xExtent = s.getWidth() - this.left;
                for (i = 0; i < this.left; ++i) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
            } else {
                xExtent = s.getWidth();
                for (i = 0; i < this.left; ++i) {
                    canvas.drawRectangle(i, i, xExtent - 2 * i, s.getHeight() - 2 * i, color);
                }
                canvas.drawLine(xExtent - 13, this.top, xExtent - 13, this.top + s.getHeight(), color);
                canvas.drawSolidRectangle(xExtent - 13 + 1, this.top, 11, s.getHeight() - 2 * this.top, Toolkit.getColor("color.secondary3"));
            }
        }
    }

    public void entered() {
        this.getState().setContentIdentified();
        this.getState().setViewIdentified();
        this.wrappedView.entered();
        this.markDamaged();
    }

    public void exited() {
        this.getState().clearObjectIdentified();
        this.getState().clearViewIdentified();
        this.wrappedView.exited();
        this.markDamaged();
    }

    public void keyPressed(KeyboardAction key) {
        if (key.getKeyCode() == 32 && this.isNodeSelectable()) {
            this.selectNode();
        } else {
            super.keyPressed(key);
        }
    }

    private boolean isNodeSelectable() {
        return this.getViewAxis() instanceof SelectableViewAxis;
    }

    public void firstClick(Click click) {
        int y;
        int x = click.getLocation().getX();
        if (this.withinSelectorBounds(x, y = click.getLocation().getY()) && click.button1() && this.isNodeSelectable()) {
            this.selectNode();
        } else {
            super.firstClick(click);
        }
    }

    private void selectNode() {
        ((SelectableViewAxis)this.getViewAxis()).selected(this.getView());
    }

    private boolean withinSelectorBounds(int x, int y) {
        return true;
    }

    public void viewMenuOptions(UserActionSet options) {
        super.viewMenuOptions(options);
        if (this.isNodeSelectable()) {
            options.add(new AbstractUserAction("Select node"){

                public void execute(Workspace workspace, View view, Location at) {
                    ObjectBorder.this.selectNode();
                }

                public String getDescription(View view) {
                    return "Show this node in the right-hand pane";
                }
            });
        }
    }

    public String toString() {
        return this.wrappedView.toString() + "/ObjectBorder [" + this.getSpecification() + "]";
    }
}

