/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.border;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.plugins.dndviewer.ButtonAction;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.FieldContent;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewSpecification;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.action.AbstractButtonAction;
import org.nakedobjects.plugins.dndviewer.viewer.border.ButtonBorder;
import org.nakedobjects.plugins.dndviewer.viewer.border.SaveState;
import org.nakedobjects.plugins.dndviewer.viewer.content.RootObject;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.runtime.context.NakedObjectsContext;
import org.nakedobjects.runtime.persistence.PersistenceSession;
import org.nakedobjects.runtime.transaction.NakedObjectTransactionManager;

class SaveTransientObjectBorder
extends ButtonBorder {
    private static final Logger LOG = Logger.getLogger(SaveTransientObjectBorder.class);

    private static Consent canSave(View view) {
        NakedObject transientNO = view.getContent().getNaked();
        SaveState saveState = new SaveState();
        SaveTransientObjectBorder.checkFields(saveState, view, transientNO);
        StringBuilder errorBuf = new StringBuilder(saveState.getMessage());
        NakedObjectSpecification viewContentSpec = view.getContent().getSpecification();
        Consent consent = viewContentSpec.isValid(transientNO);
        if (consent.isVetoed()) {
            if (errorBuf.length() > 0) {
                errorBuf.append("; ");
            }
            errorBuf.append(consent.getReason());
        }
        if (errorBuf.length() == 0) {
            return Allow.DEFAULT;
        }
        return new Veto(errorBuf.toString());
    }

    private static void checkFields(SaveState saveState, View view, NakedObject forObject) {
        if (view.getContent().getNaked() != forObject) {
            return;
        }
        View[] subviews = view.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            String parameterName;
            boolean isFieldEmpty;
            View fieldView = subviews[i];
            Content content = fieldView.getContent();
            if (content instanceof RootObject) {
                SaveTransientObjectBorder.checkFields(saveState, fieldView, forObject);
                continue;
            }
            if (!(content instanceof FieldContent)) continue;
            boolean isMandatory = ((FieldContent)content).isMandatory();
            NakedObject field = content.getNaked();
            boolean bl = isFieldEmpty = field == null;
            if (isMandatory && isFieldEmpty) {
                parameterName = ((FieldContent)content).getFieldName();
                saveState.addMissingField(parameterName);
                continue;
            }
            if (!fieldView.getState().isInvalid()) continue;
            parameterName = ((FieldContent)content).getFieldName();
            saveState.addInvalidField(parameterName);
        }
    }

    private static void close(Workspace workspace, View view) {
        view.dispose();
    }

    private static NakedObject save(View view) {
        NakedObject transientObject = view.getContent().getNaked();
        try {
            SaveTransientObjectBorder.getPersistenceSession().makePersistent(transientObject);
        }
        catch (RuntimeException e) {
            LOG.info((Object)("exception saving " + transientObject + ", aborting transaction"), (Throwable)e);
            throw e;
        }
        return transientObject;
    }

    public SaveTransientObjectBorder(View view) {
        super(new ButtonAction[]{new SaveAction(), new SaveAndCloseAction(), new CloseAction()}, view);
    }

    private static PersistenceSession getPersistenceSession() {
        return NakedObjectsContext.getPersistenceSession();
    }

    private static NakedObjectTransactionManager getTransactionManager() {
        return SaveTransientObjectBorder.getPersistenceSession().getTransactionManager();
    }

    private static class SaveAndCloseAction
    extends AbstractButtonAction {
        public SaveAndCloseAction() {
            super("Save & Close");
        }

        public Consent disabled(View view) {
            return SaveTransientObjectBorder.canSave(view);
        }

        public void execute(Workspace workspace, View view, Location at) {
            SaveTransientObjectBorder.save(view);
            SaveTransientObjectBorder.close(workspace, view);
        }
    }

    private static class SaveAction
    extends AbstractButtonAction {
        public SaveAction() {
            super("Save");
        }

        public Consent disabled(View view) {
            return SaveTransientObjectBorder.canSave(view);
        }

        public void execute(Workspace workspace, View view, Location at) {
            SaveTransientObjectBorder.save(view);
            ViewSpecification spec = view.getSpecification();
            View newView = spec.createView(view.getContent(), null);
            workspace.replaceView(view, newView);
        }
    }

    private static class CloseAction
    extends AbstractButtonAction {
        public CloseAction() {
            super("Discard");
        }

        public void execute(Workspace workspace, View view, Location at) {
            SaveTransientObjectBorder.close(workspace, view);
        }
    }
}

