/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.builder;

import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractBuilderDecorator;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;

public class ColumnLayout
extends AbstractBuilderDecorator {
    private final boolean fixedWidth;

    public ColumnLayout(ViewBuilder design) {
        super(design);
        this.fixedWidth = false;
    }

    public ColumnLayout(ViewBuilder design, boolean fixedWidth) {
        super(design);
        this.fixedWidth = fixedWidth;
    }

    public Size getRequiredSize(View view) {
        int height = 0;
        int width = 0;
        int maxWidth = 0;
        View[] views = view.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            Size s = v.getRequiredSize(new Size(Integer.MAX_VALUE, Integer.MAX_VALUE));
            width += s.getWidth();
            maxWidth = Math.max(maxWidth, s.getWidth());
            height = Math.max(height, s.getHeight());
        }
        if (this.fixedWidth) {
            width = maxWidth / 2 * views.length;
        }
        return new Size(width, height);
    }

    public boolean isOpen() {
        return true;
    }

    public void layout(View view, Size maximumSize) {
        Size s;
        View v;
        int i;
        int x = 0;
        boolean y = false;
        View[] subviews = view.getSubviews();
        int maxWidth = 0;
        for (i = 0; i < subviews.length; ++i) {
            v = subviews[i];
            v.layout(new Size(maximumSize));
            s = v.getRequiredSize(new Size(maximumSize));
            maxWidth = Math.max(maxWidth, s.getWidth());
        }
        for (i = 0; i < subviews.length; ++i) {
            v = subviews[i];
            s = v.getRequiredSize(new Size(maximumSize));
            v.setLocation(new Location(x, 0));
            if (this.fixedWidth || v.getSpecification().isAligned()) {
                x += maxWidth / 2;
                s.setWidth(maxWidth / 2);
            } else {
                x += s.getWidth();
            }
            v.setSize(s);
        }
    }
}

