/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.builder;

import org.nakedobjects.plugins.dndviewer.LabelAxis;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.ViewBuilder;
import org.nakedobjects.plugins.dndviewer.viewer.builder.AbstractBuilderDecorator;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Size;

public class LabelledFieldLayout
extends AbstractBuilderDecorator {
    public LabelledFieldLayout(ViewBuilder design) {
        super(design);
    }

    public Size getRequiredSize(View view) {
        int height = 0;
        int width = 0;
        View[] views = view.getSubviews();
        for (int i = 0; i < views.length; ++i) {
            View v = views[i];
            Size s = v.getRequiredSize(new Size());
            height = Math.max(height, s.getHeight());
            width += s.getWidth();
        }
        return new Size(width += View.HPADDING, height);
    }

    public boolean isOpen() {
        return false;
    }

    public void layout(View view, Size maximumSize) {
        int x = 0;
        boolean y = false;
        View[] subviews = view.getSubviews();
        for (int i = 0; i < subviews.length; ++i) {
            View v = subviews[i];
            v.layout(maximumSize);
            Size s = v.getRequiredSize(new Size());
            v.setSize(s);
            v.setLocation(new Location(x, 0));
            x = ((LabelAxis)v.getViewAxis()).getWidth() + View.HPADDING;
        }
    }
}

