/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.content;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.plugins.dndviewer.BackgroundTask;
import org.nakedobjects.plugins.dndviewer.BackgroundThread;
import org.nakedobjects.plugins.dndviewer.View;
import org.nakedobjects.plugins.dndviewer.Workspace;
import org.nakedobjects.plugins.dndviewer.viewer.content.AbstractObjectOption;
import org.nakedobjects.plugins.dndviewer.viewer.drawing.Location;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class ImmediateObjectOption
extends AbstractObjectOption {
    public static ImmediateObjectOption createOption(NakedObjectAction action, NakedObject object) {
        Assert.assertTrue((String)"Only suitable for 0 param methods", (action.getParameterCount() == 0 ? 1 : 0) != 0);
        if (!action.isVisible(NakedObjectsContext.getAuthenticationSession(), object).isAllowed()) {
            return null;
        }
        ImmediateObjectOption option = new ImmediateObjectOption(action, object);
        return option;
    }

    public static ImmediateObjectOption createServiceOption(NakedObjectAction action, NakedObject object) {
        Assert.assertTrue((String)"Only suitable for 1 param methods", (action.getParameterCount() == 1 ? 1 : 0) != 0);
        if (!action.isVisible(NakedObjectsContext.getAuthenticationSession(), object).isAllowed()) {
            return null;
        }
        ImmediateObjectOption option = new ImmediateObjectOption(action, object);
        return option;
    }

    private ImmediateObjectOption(NakedObjectAction action, NakedObject target) {
        super(action, target, action.getName());
    }

    protected Consent checkValid() {
        return this.action.isProposedArgumentSetValid(this.target, null);
    }

    public void execute(Workspace workspace, final View view, final Location at) {
        BackgroundThread.newRun(view, new BackgroundTask(){

            public void execute() {
                NakedObject result = ImmediateObjectOption.this.action.execute(ImmediateObjectOption.this.target, null);
                if (result != null) {
                    CollectionFacet facet = (CollectionFacet)result.getSpecification().getFacet(CollectionFacet.class);
                    if (facet != null && facet.size(result) == 1) {
                        result = facet.firstElement(result);
                    }
                    view.objectActionResult(result, at);
                }
                view.getViewManager().disposeUnneededViews();
                view.getFeedbackManager().showMessagesAndWarnings();
            }

            public String getDescription() {
                return "Running action " + this.getName() + " on  " + view.getContent().getNaked();
            }

            public String getName() {
                return "NakedObjectAction " + ImmediateObjectOption.this.action.getName();
            }
        });
    }
}

