/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.content;

import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.plugins.dndviewer.OneToManyFieldElement;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.viewer.content.AbstractObjectContent;
import org.nakedobjects.plugins.dndviewer.viewer.content.ClearOneToManyAssociationOption;
import org.nakedobjects.plugins.dndviewer.viewer.content.ObjectField;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class OneToManyFieldElementImpl
extends AbstractObjectContent
implements OneToManyFieldElement {
    private static final Logger LOG = Logger.getLogger(OneToManyFieldElementImpl.class);
    private final NakedObject element;
    private final ObjectField field;

    public OneToManyFieldElementImpl(NakedObject parent, NakedObject element, OneToManyAssociation association) {
        this.field = new ObjectField(parent, (NakedObjectAssociation)association);
        this.element = element;
    }

    public Consent canClear() {
        NakedObject parentObject = this.getParent();
        OneToManyAssociation association = this.getOneToManyAssociation();
        NakedObject associatedObject = this.getObject();
        Consent isEditable = this.isEditable();
        if (isEditable.isVetoed()) {
            return isEditable;
        }
        Consent consent = association.isValidToRemove(parentObject, associatedObject);
        if (consent.isAllowed()) {
            consent.setDescription("Clear the association to this object from '" + parentObject.titleString() + "'");
        }
        return consent;
    }

    public Consent isEditable() {
        return this.getField().isUsable(NakedObjectsContext.getAuthenticationSession(), this.getParent());
    }

    public Consent canSet(NakedObject dragSource) {
        return Veto.DEFAULT;
    }

    public void clear() {
        NakedObject parentObject = this.getParent();
        OneToManyAssociation association = this.getOneToManyAssociation();
        LOG.debug((Object)("remove " + this.element + " from " + parentObject));
        association.removeElement(parentObject, this.element);
    }

    public void debugDetails(DebugString debug) {
        this.field.debugDetails(debug);
        debug.appendln("element", (Object)this.element);
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public NakedObjectAssociation getField() {
        return this.field.getNakedObjectAssociation();
    }

    public NakedObject getNaked() {
        return this.element;
    }

    public NakedObject getObject() {
        return this.element;
    }

    public NakedObject[] getOptions() {
        return null;
    }

    private OneToManyAssociation getOneToManyAssociation() {
        return (OneToManyAssociation)this.field.getNakedObjectAssociation();
    }

    public NakedObject getParent() {
        return this.field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return this.field.getSpecification();
    }

    public boolean isMandatory() {
        return false;
    }

    public boolean isObject() {
        return true;
    }

    public boolean isOptionEnabled() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        options.add(new ClearOneToManyAssociationOption());
    }

    public void setObject(NakedObject object) {
    }

    public String title() {
        return this.element.titleString();
    }

    public String toString() {
        return this.getObject() + "/" + this.field.getNakedObjectAssociation();
    }

    public String windowTitle() {
        return this.field.getName() + " element" + " for " + this.field.getParent().titleString();
    }

    public String getId() {
        return this.getOneToManyAssociation().getName();
    }

    public String getDescription() {
        return this.field.getName() + ": " + this.getOneToManyAssociation().getDescription();
    }

    public String getHelp() {
        return this.getOneToManyAssociation().getHelp();
    }
}

