/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.content;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.dndviewer.OneToOneField;
import org.nakedobjects.plugins.dndviewer.UserAction;
import org.nakedobjects.plugins.dndviewer.UserActionSet;
import org.nakedobjects.plugins.dndviewer.viewer.content.AbstractObjectContent;
import org.nakedobjects.plugins.dndviewer.viewer.content.ClearOneToOneAssociationOption;
import org.nakedobjects.plugins.dndviewer.viewer.content.ObjectField;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class OneToOneFieldImpl
extends AbstractObjectContent
implements OneToOneField {
    private static final UserAction CLEAR_ASSOCIATION = new ClearOneToOneAssociationOption();
    private final ObjectField field;
    private final NakedObject adapter;

    public OneToOneFieldImpl(NakedObject parentAdapter, NakedObject adapter, OneToOneAssociation association) {
        this.field = new ObjectField(parentAdapter, (NakedObjectAssociation)association);
        this.adapter = adapter;
    }

    public Consent canClear() {
        NakedObject parentAdapter = this.getParent();
        OneToOneAssociation association = this.getOneToOneAssociation();
        Consent isEditable = this.isEditable();
        if (isEditable.isVetoed()) {
            return isEditable;
        }
        Consent consent = association.isAssociationValid(parentAdapter, null);
        if (consent.isAllowed()) {
            consent.setDescription("Clear the association to this object from '" + parentAdapter.titleString() + "'");
        }
        return consent;
    }

    public Consent canSet(NakedObject adapter) {
        NakedObjectSpecification targetType = this.getOneToOneAssociation().getSpecification();
        NakedObjectSpecification spec = adapter.getSpecification();
        if (this.isEditable().isVetoed()) {
            return this.isEditable();
        }
        if (!spec.isOfType(targetType)) {
            return new Veto(String.format("Can only drop objects of type %s", targetType.getSingularName()));
        }
        if (this.getParent().isPersistent() && adapter.isTransient()) {
            return new Veto("Can't drop a non-persistent into this persistent object");
        }
        Consent perm = this.getOneToOneAssociation().isAssociationValid(this.getParent(), adapter);
        return perm;
    }

    public void clear() {
        this.getOneToOneAssociation().clearAssociation(this.getParent());
    }

    public void debugDetails(DebugString debug) {
        this.field.debugDetails(debug);
        debug.appendln("object", (Object)this.adapter);
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public NakedObjectAssociation getField() {
        return this.field.getNakedObjectAssociation();
    }

    public Consent isEditable() {
        return this.getField().isUsable(NakedObjectsContext.getAuthenticationSession(), this.getParent());
    }

    public NakedObject getNaked() {
        return this.adapter;
    }

    public NakedObject getObject() {
        return this.adapter;
    }

    private OneToOneAssociation getOneToOneAssociation() {
        return (OneToOneAssociation)this.getField();
    }

    public NakedObject[] getOptions() {
        return this.getOneToOneAssociation().getChoices(this.getParent());
    }

    public NakedObject getParent() {
        return this.field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return this.getOneToOneAssociation().getSpecification();
    }

    public boolean isMandatory() {
        return this.getOneToOneAssociation().isMandatory();
    }

    public boolean isPersistable() {
        return this.getObject() != null && super.isPersistable();
    }

    public boolean isObject() {
        return true;
    }

    public boolean isOptionEnabled() {
        return this.getOneToOneAssociation().hasChoices();
    }

    public boolean isTransient() {
        return this.adapter != null && this.adapter.isTransient();
    }

    public void contentMenuOptions(UserActionSet options) {
        super.contentMenuOptions(options);
        if (this.getObject() != null && !this.getOneToOneAssociation().isMandatory()) {
            options.add(CLEAR_ASSOCIATION);
        }
    }

    public void setObject(NakedObject object) {
        this.getOneToOneAssociation().setAssociation(this.getParent(), object);
    }

    public String title() {
        return this.adapter == null ? "" : this.adapter.titleString();
    }

    public String toString() {
        return this.getObject() + "/" + this.getField();
    }

    public String windowTitle() {
        return this.field.getName() + " for " + this.field.getParent().titleString();
    }

    public String getId() {
        return this.getOneToOneAssociation().getName();
    }

    public String getDescription() {
        String type;
        String name = this.getFieldName();
        type = name.indexOf(type = this.getField().getSpecification().getSingularName()) == -1 ? " (" + type + ")" : "";
        String description = this.getOneToOneAssociation().getDescription();
        return name + type + " " + description;
    }

    public String getHelp() {
        return this.getOneToOneAssociation().getHelp();
    }
}

