/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.plugins.dndviewer.viewer.content;

import org.nakedobjects.metamodel.adapter.InvalidEntryException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.Veto;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacet;
import org.nakedobjects.metamodel.facets.propparam.multiline.MultiLineFacet;
import org.nakedobjects.metamodel.facets.propparam.typicallength.TypicalLengthFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.maxlength.MaxLengthFacet;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAssociation;
import org.nakedobjects.metamodel.spec.feature.OneToOneAssociation;
import org.nakedobjects.plugins.dndviewer.Content;
import org.nakedobjects.plugins.dndviewer.TextParseableField;
import org.nakedobjects.plugins.dndviewer.viewer.content.AbstractTextParsableContent;
import org.nakedobjects.plugins.dndviewer.viewer.content.ObjectField;
import org.nakedobjects.runtime.context.NakedObjectsContext;

public class TextParseableFieldImpl
extends AbstractTextParsableContent
implements TextParseableField {
    private final ObjectField field;
    private final NakedObject parent;
    private NakedObject object;

    public TextParseableFieldImpl(NakedObject parent, NakedObject object, OneToOneAssociation association) {
        this.field = new ObjectField(parent, (NakedObjectAssociation)association);
        this.parent = parent;
        this.object = object;
    }

    public Consent canDrop(Content sourceContent) {
        return Veto.DEFAULT;
    }

    public boolean canClear() {
        return true;
    }

    public boolean canWrap() {
        return this.getValueAssociation().containsFacet(MultiLineFacet.class);
    }

    public void clear() {
    }

    public void debugDetails(DebugString debug) {
        this.field.debugDetails(debug);
        debug.appendln("object", (Object)this.object);
    }

    public NakedObject drop(Content sourceContent) {
        return null;
    }

    public void entryComplete() {
        this.getValueAssociation().setAssociation(this.getParent(), this.object);
    }

    public String getDescription() {
        String title = this.object == null ? "" : ": " + this.object.titleString();
        String name = this.field.getName();
        NakedObjectSpecification specification = this.getSpecification();
        String type = name.indexOf(specification.getShortName()) == -1 ? "" : " (" + specification.getShortName() + ")";
        String description = this.getValueAssociation().getDescription();
        return name + type + title + " " + description;
    }

    public String getHelp() {
        return this.field.getHelp();
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public NakedObjectAssociation getField() {
        return this.field.getNakedObjectAssociation();
    }

    public String getIconName() {
        return this.object == null ? "" : this.object.getIconName();
    }

    public NakedObject getNaked() {
        return this.object;
    }

    public String getId() {
        return this.field.getName();
    }

    public NakedObject[] getOptions() {
        return this.getValueAssociation().getChoices(this.getParent());
    }

    private OneToOneAssociation getValueAssociation() {
        return (OneToOneAssociation)this.getField();
    }

    public int getMaximumLength() {
        return this.maxLengthFacet().value();
    }

    public int getTypicalLineLength() {
        TypicalLengthFacet facet = (TypicalLengthFacet)this.field.getNakedObjectAssociation().getFacet(TypicalLengthFacet.class);
        return facet.value();
    }

    public int getNoLines() {
        return this.multilineFacet().numberOfLines();
    }

    public NakedObject getParent() {
        return this.field.getParent();
    }

    public NakedObjectSpecification getSpecification() {
        return this.getValueAssociation().getSpecification();
    }

    public Consent isEditable() {
        return this.getValueAssociation().isUsable(NakedObjectsContext.getAuthenticationSession(), this.getParent());
    }

    public boolean isEmpty() {
        return this.getField().isEmpty(this.getParent());
    }

    public boolean isMandatory() {
        return this.getValueAssociation().isMandatory();
    }

    public boolean isOptionEnabled() {
        return this.getValueAssociation().hasChoices();
    }

    public String titleString(NakedObject value) {
        return this.titleString(value, (FacetHolder)this.field.getNakedObjectAssociation(), (FacetHolder)this.field.getSpecification());
    }

    private NakedObject validateAndParse(String entryText) {
        NakedObject newValue = this.parse(entryText);
        OneToOneAssociation nakedObjectAssociation = (OneToOneAssociation)this.field.getNakedObjectAssociation();
        Consent valid = nakedObjectAssociation.isAssociationValid(this.parent, newValue);
        if (valid.isVetoed()) {
            throw new InvalidEntryException(valid.getReason());
        }
        return newValue;
    }

    private NakedObject parse(String entryText) {
        NakedObjectSpecification fieldSpecification = this.field.getSpecification();
        ParseableFacet p = (ParseableFacet)fieldSpecification.getFacet(ParseableFacet.class);
        try {
            return p.parseTextEntry(this.object, entryText);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidEntryException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void parseTextEntry(String entryText) {
        this.object = this.validateAndParse(entryText);
        Consent valid = ((OneToOneAssociation)this.getField()).isAssociationValid(this.getParent(), this.object);
        if (valid.isVetoed()) {
            throw new InvalidEntryException(valid.getReason());
        }
        if (this.getValueAssociation().isMandatory() && this.object == null) {
            throw new InvalidEntryException("Mandatory field cannot be empty");
        }
    }

    public String title() {
        return this.field.getName();
    }

    public String toString() {
        return (this.object == null ? "null" : this.object.titleString()) + "/" + this.getField();
    }

    public String windowTitle() {
        return this.title();
    }

    private MaxLengthFacet maxLengthFacet() {
        return (MaxLengthFacet)this.getValueAssociation().getFacet(MaxLengthFacet.class);
    }

    private MultiLineFacet multilineFacet() {
        return (MultiLineFacet)this.getValueAssociation().getFacet(MultiLineFacet.class);
    }
}

